/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.context;

import io.dingodb.common.codec.DingoCodec;
import io.dingodb.common.codec.KeyValueCodec;
import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.filter.DingoFilter;
import io.dingodb.common.table.DingoKeyValueCodec;
import io.dingodb.common.table.TableDefinition;

public abstract class OperationContext {
    public final Column[] columns;
    public TableDefinition definition;
    public DingoFilter filter;
    public byte[] primaryStartKey;
    public byte[] primaryEndKey;

    public OperationContext(Column[] columns) {
        this.columns = columns;
    }

    public OperationContext definition(TableDefinition definition) {
        this.definition = definition;
        return this;
    }

    public OperationContext startKey(byte[] primaryStartKey) {
        this.primaryStartKey = primaryStartKey;
        return this;
    }

    public OperationContext endKey(byte[] primaryEndKey) {
        this.primaryEndKey = primaryEndKey;
        return this;
    }

    public void filter(DingoFilter filter) {
        this.filter = filter;
    }

    public DingoCodec dingoValueCodec() {
        return new DingoCodec(this.definition.getDingoSchemaOfValue());
    }

    public DingoCodec dingoKeyCodec() {
        return new DingoCodec(this.definition.getDingoSchemaOfKey(), null, true);
    }

    public KeyValueCodec keyValueCodec() {
        return new DingoKeyValueCodec(this.definition.getDingoType(), this.definition.getKeyMapping());
    }
}

