/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.executive;

import io.dingodb.common.codec.DingoCodec;
import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.compute.number.ComputeNumber;
import io.dingodb.common.operation.context.BasicContext;
import io.dingodb.common.operation.executive.NumberExecutive;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.TupleMapping;
import io.dingodb.common.type.converter.ClientConverter;
import io.dingodb.common.type.converter.DingoConverter;
import io.dingodb.common.util.ByteArrayUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddExecutive
extends NumberExecutive<BasicContext, Iterator<KeyValue>, Object> {
    private static final Logger log = LoggerFactory.getLogger(AddExecutive.class);

    @Override
    public List<KeyValue> execute(BasicContext context, Iterator<KeyValue> records) {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        try {
            DingoType dingoType;
            Object value;
            Column[] columns = context.columns;
            TableDefinition definition = context.definition;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = definition.getColumnIndexOfValue(columns[i].name);
            }
            int totalCnt = 0;
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                ++totalCnt;
                if (context.filter != null && !context.filter.filter(context, keyValue)) continue;
                try {
                    Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                    Object[] values = new Object[objects.length];
                    for (int i = 0; i < objects.length; ++i) {
                        DingoType dingoType2 = Objects.requireNonNull(definition.getColumn(columns[i].name)).getDingoType();
                        Object v = columns[i].value.getObject();
                        ComputeNumber number = AddExecutive.convertType(v == null ? Integer.valueOf(0) : v, dingoType2);
                        value = number.add(AddExecutive.convertType(objects[i], dingoType2));
                        values[i] = value.value().getObject();
                    }
                    dingoType = this.getDingoType(context);
                    Object[] converted = (Object[])dingoType.convertFrom(values, ClientConverter.INSTANCE);
                    byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), converted, indexes);
                    keyValue.setValue(bytes);
                    list.add(keyValue);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (context.useDefaultWhenNotExisted && totalCnt == 0 && ByteArrayUtils.equal(context.primaryStartKey, context.primaryEndKey)) {
                List columnDefinitions = definition.getColumns().stream().filter(c -> !c.isPrimary()).collect(Collectors.toList());
                Object[] defValues = columnDefinitions.stream().map(ColumnDefinition::getDefaultValue).toArray();
                for (ColumnDefinition column : columnDefinitions) {
                    if (!column.isNotNull() || column.getDefaultValue() != null) continue;
                    throw new IllegalArgumentException("Missing default value for fields that do not allow null");
                }
                for (int i = 0; i < indexes.length; ++i) {
                    dingoType = Objects.requireNonNull(definition.getColumn(columns[i].name)).getDingoType();
                    Object v = columns[i].value.getObject();
                    ComputeNumber number = AddExecutive.convertType(v == null ? Integer.valueOf(0) : v, dingoType);
                    Object defValue = defValues[indexes[i]];
                    value = number.add(AddExecutive.convertType(defValue == null ? Integer.valueOf(0) : defValue, dingoType));
                    defValues[indexes[i]] = value.value().getObject();
                }
                DingoType schema = definition.getDingoType(false);
                TupleMapping valueMapping = definition.getValueMapping();
                DingoCodec valueCodec = new DingoCodec(schema.toDingoSchemas(), valueMapping);
                Object[] objects = (Object[])schema.parse(defValues);
                Object[] value2 = (Object[])schema.convertTo(objects, DingoConverter.INSTANCE);
                byte[] bytes = valueCodec.encode(value2);
                KeyValue keyValue = new KeyValue(context.primaryStartKey, bytes);
                list.add(keyValue);
            }
        }
        catch (Exception e) {
            log.error("add failed to execute, e: ", e);
        }
        return list;
    }
}

