/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.executive;

import io.dingodb.common.operation.DingoExecResult;
import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.NumericType;
import io.dingodb.common.operation.context.BasicContext;
import io.dingodb.common.operation.executive.NumberExecutive;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.table.TableDefinition;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountExecutive
extends NumberExecutive<BasicContext, Iterator<KeyValue>, Object> {
    private static final Logger log = LoggerFactory.getLogger(CountExecutive.class);

    @Override
    public DingoExecResult execute(BasicContext context, Iterator<KeyValue> records) {
        int[] keyIndex = CountExecutive.getKeyIndex(context);
        int[] valueIndex = CountExecutive.getValueIndex(context);
        TableDefinition definition = context.definition;
        HashMap<String, Value> result = new HashMap<String, Value>();
        while (records.hasNext()) {
            KeyValue keyValue = records.next();
            if (context.filter != null && !context.filter.filter(context, keyValue)) continue;
            try {
                int i;
                Object[] objects;
                if (valueIndex.length > 0) {
                    objects = context.dingoValueCodec().decode(keyValue.getValue(), valueIndex);
                    for (i = 0; i < objects.length; ++i) {
                        Object obj = objects[i];
                        if (obj == null) continue;
                        String name = definition.getColumn(valueIndex[i] + definition.getPrimaryKeyCount()).getName();
                        Value v = (Value)result.get(name);
                        v = v == null ? Value.get(1) : Value.get(v.value().intValue() + 1);
                        result.put(name, v);
                    }
                }
                if (keyIndex.length <= 0) continue;
                objects = context.dingoKeyCodec().decodeKey(keyValue.getKey(), valueIndex);
                for (i = 0; i < objects.length; ++i) {
                    Value v = (Value)result.get(definition.getColumn(keyIndex[i]).getName());
                    v = v == null ? Value.get(1) : Value.get(v.value().intValue() + 1);
                    result.put(definition.getColumn(keyIndex[i]).getName(), v);
                }
            }
            catch (IOException e) {
                log.error("Column:{} decode failed", Arrays.stream(context.columns).map(col -> col.name).toArray());
                return new DingoExecResult(false, "count operation decode failed, " + e.getMessage());
            }
        }
        return new DingoExecResult(result, true, "OK", NumericType.COUNT.name());
    }
}

