/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.executive;

import io.dingodb.common.operation.DingoExecResult;
import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.NumericType;
import io.dingodb.common.operation.compute.number.ComputeNumber;
import io.dingodb.common.operation.context.BasicContext;
import io.dingodb.common.operation.executive.NumberExecutive;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.common.type.DingoType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumExecutive
extends NumberExecutive<BasicContext, Iterator<KeyValue>, Object> {
    private static final Logger log = LoggerFactory.getLogger(SumExecutive.class);

    @Override
    public DingoExecResult execute(BasicContext context, Iterator<KeyValue> records) {
        int[] keyIndex = SumExecutive.getKeyIndex(context);
        int[] valueIndex = SumExecutive.getValueIndex(context);
        HashMap<String, ComputeNumber> map = new HashMap<String, ComputeNumber>();
        HashMap<String, Value> result = new HashMap<String, Value>();
        TableDefinition definition = context.definition;
        while (records.hasNext()) {
            KeyValue keyValue = records.next();
            if (context.filter != null && !context.filter.filter(context, keyValue)) continue;
            try {
                Object[] objects;
                if (keyIndex.length > 0) {
                    objects = context.dingoKeyCodec().decodeKey(keyValue.getKey(), keyIndex);
                    for (int i = 0; i < objects.length; ++i) {
                        DingoType dingoType = definition.getColumn(keyIndex[i]).getDingoType();
                        ComputeNumber number = SumExecutive.convertType(objects[i], dingoType);
                        map.merge(definition.getColumn(keyIndex[i]).getName(), number, ComputeNumber::add);
                    }
                }
                if (valueIndex.length <= 0) continue;
                objects = context.dingoValueCodec().decode(keyValue.getValue(), valueIndex);
                int keyCount = definition.getPrimaryKeyCount();
                for (int i = 0; i < objects.length; ++i) {
                    ColumnDefinition columnDefinition = definition.getColumn(valueIndex[i] + keyCount);
                    ComputeNumber number = SumExecutive.convertType(objects[i], columnDefinition.getDingoType());
                    map.merge(columnDefinition.getName(), number, ComputeNumber::add);
                }
            }
            catch (IOException e) {
                log.error("Column:{} decode failed", Arrays.stream(context.columns).map(col -> col.name).toArray());
                return new DingoExecResult(false, "Sum operation decode failed, " + e.getMessage());
            }
        }
        map.forEach((key, value) -> result.put((String)key, value.value()));
        return new DingoExecResult(result, true, "OK", NumericType.SUM.name());
    }
}

