/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.executive;

import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.context.BasicContext;
import io.dingodb.common.operation.executive.BasicExecutive;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.common.type.DingoType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateExecutive
extends BasicExecutive<BasicContext, Iterator<KeyValue>, Object> {
    private static final Logger log = LoggerFactory.getLogger(UpdateExecutive.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<KeyValue> execute(BasicContext context, Iterator<KeyValue> record) {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        try {
            Column[] columns = context.columns;
            TableDefinition definition = context.definition;
            int[] indexes = new int[columns.length];
            Object[] values = new Object[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = definition.getColumnIndexOfValue(columns[i].name);
            }
            while (record.hasNext()) {
                KeyValue keyValue = record.next();
                boolean filter = context.filter == null ? true : context.filter.filter(context, keyValue);
                if (!filter) continue;
                try {
                    for (int i = 0; i < columns.length; ++i) {
                        DingoType dingoType = Objects.requireNonNull(definition.getColumn(columns[i].name)).getDingoType();
                        values[i] = dingoType.parse(columns[i].value.getObject());
                    }
                    byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), values, indexes);
                    keyValue.setValue(bytes);
                    list.add(keyValue);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return list;
                }
            }
        }
        catch (Exception ex) {
            log.error("Field update execution failed, e: ", ex);
        }
        return list;
    }
}

