/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.filter;

import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.store.KeyValue;
import java.io.IOException;
import java.util.Arrays;

public interface DingoFilter {
    public boolean filter(OperationContext var1, KeyValue var2);

    public void addOrFilter(DingoFilter var1);

    public void addAndFilter(DingoFilter var1);

    default public int[] getKeyIndex(OperationContext context, int[] indexes) {
        return Arrays.stream(indexes).filter(i -> context.definition.getColumn(i).isPrimary()).toArray();
    }

    default public int[] getValueIndex(OperationContext context, int[] indexes) {
        return Arrays.stream(indexes).filter(i -> !context.definition.getColumn(i).isPrimary()).map(i -> i - context.definition.getPrimaryKeyCount()).toArray();
    }

    default public Object[] getRecord(int[] keyIndex, int[] valueIndex, KeyValue keyValue, OperationContext context) throws IOException {
        if (keyIndex.length > 0 && valueIndex.length > 0) {
            Object[] recordKey = context.dingoKeyCodec().decodeKey(keyValue.getKey(), keyIndex);
            Object[] recordValue = context.dingoValueCodec().decode(keyValue.getValue(), valueIndex);
            Object[] record0 = new Object[keyIndex.length + valueIndex.length];
            System.arraycopy(recordKey, 0, record0, 0, recordKey.length);
            System.arraycopy(recordValue, 0, record0, recordKey.length, recordValue.length);
            return record0;
        }
        if (keyIndex.length > 0) {
            Object[] recordKey = context.dingoKeyCodec().decodeKey(keyValue.getKey(), keyIndex);
            return recordKey;
        }
        if (valueIndex.length > 0) {
            Object[] recordValue = context.dingoValueCodec().decode(keyValue.getValue(), valueIndex);
            return recordValue;
        }
        return null;
    }
}

