/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.filter.impl;

import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.operation.filter.AbstractDingoFilter;
import io.dingodb.common.store.KeyValue;
import java.io.IOException;

public class DingoDateRangeFilter
extends AbstractDingoFilter {
    private int index;
    private long startTime;
    private long endTime;

    public DingoDateRangeFilter(int index, long startTime, long endTime) {
        this.index = index;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public boolean filter(OperationContext context, KeyValue keyValue) {
        try {
            int[] keyIndex = this.getKeyIndex(context, new int[]{this.index});
            int[] valueIndex = this.getValueIndex(context, new int[]{this.index});
            Object[] record0 = this.getRecord(keyIndex, valueIndex, keyValue, context);
            return this.contain(record0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean contain(Object[] record0) {
        if (record0 == null) {
            return false;
        }
        for (Object o : record0) {
            long timestamp;
            if (!(o instanceof Long) || (timestamp = ((Long)o).longValue()) < this.startTime || timestamp >= this.endTime) continue;
            return true;
        }
        return false;
    }
}

