/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.filter.impl;

import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.operation.filter.AbstractDingoFilter;
import io.dingodb.common.store.KeyValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoNumberRangeFilter
extends AbstractDingoFilter {
    private static final Logger log = LoggerFactory.getLogger(DingoNumberRangeFilter.class);
    private int index;
    private BigDecimal startValue;
    private BigDecimal endValue;

    public DingoNumberRangeFilter(int index, Number startKey, Number endKey) {
        this.index = index;
        this.startValue = startKey == null ? null : new BigDecimal(startKey.toString());
        this.endValue = endKey == null ? null : new BigDecimal(endKey.toString());
    }

    @Override
    public boolean filter(OperationContext context, KeyValue keyValue) {
        try {
            int[] keyIndex = this.getKeyIndex(context, new int[]{this.index});
            int[] valueIndex = this.getValueIndex(context, new int[]{this.index});
            Object[] record0 = this.getRecord(keyIndex, valueIndex, keyValue, context);
            boolean isOK = false;
            for (Object o : record0) {
                BigDecimal currentValue = new BigDecimal(o.toString());
                boolean isBetween = false;
                if (this.startValue != null && this.endValue != null) {
                    boolean bl = isBetween = currentValue.compareTo(this.startValue) >= 0 && currentValue.compareTo(this.endValue) < 0;
                }
                if (this.startValue != null && this.endValue == null) {
                    boolean bl = isBetween = currentValue.compareTo(this.startValue) >= 0;
                }
                if (this.startValue == null && this.endValue != null) {
                    boolean bl = isBetween = currentValue.compareTo(this.endValue) < 0;
                }
                if (!isBetween) continue;
                isOK = true;
                break;
            }
            return isOK;
        }
        catch (IOException ex) {
            log.warn("compare number record:{} to start:{} and end:{} catch exception:{}", Arrays.toString(keyValue.getKey()), this.startValue, this.endValue, ex.toString(), ex);
            throw new RuntimeException(ex);
        }
    }
}

