/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.filter.impl;

import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.operation.filter.AbstractDingoFilter;
import io.dingodb.common.store.KeyValue;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoStringRangeFilter
extends AbstractDingoFilter {
    private static final Logger log = LoggerFactory.getLogger(DingoStringRangeFilter.class);
    private int index;
    private String startValue;
    private String endValue;

    public DingoStringRangeFilter(int index, String startKey, String endKey) {
        this.index = index;
        this.startValue = startKey;
        this.endValue = endKey;
    }

    @Override
    public boolean filter(OperationContext context, KeyValue keyValue) {
        try {
            Object[] record0;
            int[] keyIndex = this.getKeyIndex(context, new int[]{this.index});
            int[] valueIndex = this.getValueIndex(context, new int[]{this.index});
            boolean isOK = false;
            for (Object obj : record0 = this.getRecord(keyIndex, valueIndex, keyValue, context)) {
                if (obj == null) {
                    log.warn("Current input index:{} is null", (Object)this.index);
                    continue;
                }
                String objStr = obj.toString();
                if (objStr.compareTo(this.startValue) < 0 || objStr.compareTo(this.endValue) >= 0) continue;
                isOK = true;
                break;
            }
            return isOK;
        }
        catch (IOException ex) {
            log.warn("compare string record:{} to start:{} and end:{} catch exception:{}", Arrays.toString(keyValue.getKey()), this.startValue, this.endValue, ex.toString(), ex);
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) {
        String input = "dingo10";
        boolean isOK = input.compareTo("dingo1") >= 0 && input.compareTo("dingo5") <= 0;
        System.out.println(isOK);
    }
}

