/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.filter.impl;

import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.operation.filter.AbstractDingoFilter;
import io.dingodb.common.store.KeyValue;
import java.io.IOException;

public class DingoValueEqualsFilter
extends AbstractDingoFilter {
    private int[] index;
    private Object[] value;

    public DingoValueEqualsFilter(int[] index, Object[] value) {
        this.index = index;
        this.value = value;
    }

    @Override
    public boolean filter(OperationContext context, KeyValue keyValue) {
        try {
            int[] keyIndex = this.getKeyIndex(context, this.index);
            int[] valueIndex = this.getValueIndex(context, this.index);
            Object[] record0 = this.getRecord(keyIndex, valueIndex, keyValue, context);
            return this.equals(record0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean equals(Object[] record0) {
        if (record0 == null) {
            return false;
        }
        if (record0.length != this.value.length) {
            return false;
        }
        for (int i = 0; i < record0.length; ++i) {
            if (record0[i].equals(this.value[i])) continue;
            return false;
        }
        return true;
    }
}

