/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.partition;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dingodb.common.hash.SimpleHashStrategy;
import io.dingodb.common.partition.RangeStrategy;
import io.dingodb.common.type.TupleMapping;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SimpleHashStrategy.class), @JsonSubTypes.Type(value=RangeStrategy.class)})
public abstract class PartitionStrategy<I> {
    public abstract int getPartNum();

    public abstract I calcPartId(@Nonnull Object[] var1);

    public abstract I calcPartId(@Nonnull byte[] var1);

    public I calcPartId(@Nonnull Object[] tuple, @Nonnull TupleMapping keyMapping) {
        Object[] keyTuple = keyMapping.revMap(tuple);
        return this.calcPartId(keyTuple);
    }

    public abstract Map<byte[], byte[]> calcPartitionRange(@Nonnull byte[] var1, @Nonnull byte[] var2, boolean var3);

    public Map<I, List<Object[]>> partKeyTuples(@Nonnull Collection<Object[]> keyTuples) {
        LinkedHashMap map = new LinkedHashMap(this.getPartNum());
        for (Object[] tuple : keyTuples) {
            I partId = this.calcPartId(tuple);
            map.putIfAbsent(partId, new LinkedList());
            ((List)map.get(partId)).add(tuple);
        }
        return map;
    }

    public Map<I, List<Object[]>> partTuples(@Nonnull Collection<Object[]> tuples, @Nonnull TupleMapping keyMappings) {
        LinkedHashMap map = new LinkedHashMap(this.getPartNum());
        for (Object[] tuple : tuples) {
            I partId = this.calcPartId(tuple, keyMappings);
            map.putIfAbsent(partId, new LinkedList());
            ((List)map.get(partId)).add(tuple);
        }
        return map;
    }
}

