/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.codec.Codec;
import io.dingodb.common.codec.DingoCodec;
import io.dingodb.common.partition.PartitionStrategy;
import io.dingodb.common.table.TableDefinition;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.converter.DingoConverter;
import io.dingodb.common.util.ByteArrayUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"definition", "ranges"})
@JsonTypeName(value="RangeHash")
public class RangeStrategy
extends PartitionStrategy<ByteArrayUtils.ComparableByteArray> {
    @JsonProperty(value="definition")
    private final TableDefinition definition;
    @JsonProperty(value="ranges")
    private final NavigableSet<ByteArrayUtils.ComparableByteArray> ranges;
    private final transient Codec codec;
    private final transient DingoType keySchema;

    @JsonCreator
    public RangeStrategy(@Nonnull @JsonProperty(value="definition") TableDefinition definition, @JsonProperty(value="ranges") NavigableSet<ByteArrayUtils.ComparableByteArray> ranges) {
        this.ranges = ranges;
        this.definition = definition;
        this.keySchema = definition.getDingoType(true);
        this.codec = new DingoCodec(definition.getDingoSchemaOfKey(), null, true);
    }

    @Override
    public int getPartNum() {
        return this.ranges.size();
    }

    @Override
    public ByteArrayUtils.ComparableByteArray calcPartId(@Nonnull Object[] keyTuple) {
        try {
            return this.calcPartId(this.codec.encodeKey((Object[])this.keySchema.convertTo(keyTuple, DingoConverter.INSTANCE)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteArrayUtils.ComparableByteArray calcPartId(@Nonnull byte[] keyBytes) {
        return this.ranges.floor(new ByteArrayUtils.ComparableByteArray(keyBytes));
    }

    @Override
    public Map<byte[], byte[]> calcPartitionRange(@Nonnull byte[] startKey, @Nonnull byte[] endKey, boolean includeEnd) {
        TreeMap<byte[], byte[]> keyMap = new TreeMap<byte[], byte[]>(ByteArrayUtils::compare);
        LinkedHashSet<ByteArrayUtils.ComparableByteArray> keySet = new LinkedHashSet<ByteArrayUtils.ComparableByteArray>();
        for (ByteArrayUtils.ComparableByteArray key : this.ranges) {
            if (!ByteArrayUtils.greatThanOrEqual(key.getBytes(), startKey) || !ByteArrayUtils.lessThanOrEqual(key.getBytes(), endKey)) continue;
            keySet.add(key);
        }
        LinkedHashSet<ByteArrayUtils.ComparableByteArray> subSet = keySet;
        byte[] start = startKey;
        Iterator iterator = subSet.iterator();
        while (iterator.hasNext()) {
            ByteArrayUtils.ComparableByteArray sKey = (ByteArrayUtils.ComparableByteArray)iterator.next();
            if (start == null) {
                start = sKey.getBytes();
            }
            byte[] end = iterator.hasNext() ? null : endKey;
            keyMap.put(start, end);
            start = null;
        }
        return keyMap;
    }
}

