/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.partition.PartitionStrategy;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"type", "partNum"})
@JsonTypeName(value="simpleHash")
public final class SimplePartitionStrategy
extends PartitionStrategy<String> {
    @JsonProperty(value="partNum")
    private final int partNum;

    @JsonCreator
    public SimplePartitionStrategy(@JsonProperty(value="partNum") int partNum) {
        this.partNum = partNum;
    }

    @Override
    @Nonnull
    public String calcPartId(@Nonnull Object[] keyTuples) {
        int hash = Objects.hash(keyTuples);
        return Integer.toString(Math.abs(hash) % this.partNum);
    }

    @Override
    @Nonnull
    public String calcPartId(@Nonnull byte[] keyBytes) {
        int hash = Objects.hash(new Object[]{keyBytes});
        return Integer.toString(Math.abs(hash) % this.partNum);
    }

    @Override
    public Map<byte[], byte[]> calcPartitionRange(@Nonnull byte[] startKey, @Nonnull byte[] endKey, boolean includeEnd) {
        return Collections.emptyMap();
    }

    @Override
    public int getPartNum() {
        return this.partNum;
    }
}

