/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.store;

import io.dingodb.common.CommonId;
import io.dingodb.common.Location;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class Part {
    private CommonId id;
    private CommonId instanceId;
    private CommonId replicateId;
    private byte[] start;
    private byte[] end;
    private PartType type;
    private CommonId leader;
    private Location leaderLocation;
    private List<CommonId> replicates;
    private List<Location> replicateLocations;
    private int version;
    private int ttl;

    public String toString() {
        return new StringJoiner(", ", Part.class.getSimpleName() + "[", "]").add("id=" + this.id).add("instanceId=" + this.instanceId).add("start=" + Arrays.toString(this.start)).add("end=" + Arrays.toString(this.end)).add("type=" + (Object)((Object)this.type)).add("leader=" + this.leaderLocation).add("replicates=" + this.replicateLocations).add("version=" + this.version).add("ttl=" + this.ttl).toString();
    }

    private static PartType $default$type() {
        return PartType.ROW_STORE;
    }

    public static PartBuilder builder() {
        return new PartBuilder();
    }

    public CommonId getId() {
        return this.id;
    }

    public CommonId getInstanceId() {
        return this.instanceId;
    }

    public CommonId getReplicateId() {
        return this.replicateId;
    }

    public byte[] getStart() {
        return this.start;
    }

    public byte[] getEnd() {
        return this.end;
    }

    public PartType getType() {
        return this.type;
    }

    public CommonId getLeader() {
        return this.leader;
    }

    public Location getLeaderLocation() {
        return this.leaderLocation;
    }

    public List<CommonId> getReplicates() {
        return this.replicates;
    }

    public List<Location> getReplicateLocations() {
        return this.replicateLocations;
    }

    public int getVersion() {
        return this.version;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setId(CommonId id) {
        this.id = id;
    }

    public void setInstanceId(CommonId instanceId) {
        this.instanceId = instanceId;
    }

    public void setReplicateId(CommonId replicateId) {
        this.replicateId = replicateId;
    }

    public void setStart(byte[] start) {
        this.start = start;
    }

    public void setEnd(byte[] end) {
        this.end = end;
    }

    public void setType(PartType type2) {
        this.type = type2;
    }

    public void setLeader(CommonId leader) {
        this.leader = leader;
    }

    public void setLeaderLocation(Location leaderLocation) {
        this.leaderLocation = leaderLocation;
    }

    public void setReplicates(List<CommonId> replicates) {
        this.replicates = replicates;
    }

    public void setReplicateLocations(List<Location> replicateLocations) {
        this.replicateLocations = replicateLocations;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public Part() {
        this.type = Part.$default$type();
    }

    public Part(CommonId id, CommonId instanceId, CommonId replicateId, byte[] start, byte[] end, PartType type2, CommonId leader, Location leaderLocation, List<CommonId> replicates, List<Location> replicateLocations, int version, int ttl) {
        this.id = id;
        this.instanceId = instanceId;
        this.replicateId = replicateId;
        this.start = start;
        this.end = end;
        this.type = type2;
        this.leader = leader;
        this.leaderLocation = leaderLocation;
        this.replicates = replicates;
        this.replicateLocations = replicateLocations;
        this.version = version;
        this.ttl = ttl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Part)) {
            return false;
        }
        Part other = (Part)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        CommonId this$id = this.getId();
        CommonId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        CommonId this$instanceId = this.getInstanceId();
        CommonId other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
            return false;
        }
        CommonId this$replicateId = this.getReplicateId();
        CommonId other$replicateId = other.getReplicateId();
        if (this$replicateId == null ? other$replicateId != null : !((Object)this$replicateId).equals(other$replicateId)) {
            return false;
        }
        if (!Arrays.equals(this.getStart(), other.getStart())) {
            return false;
        }
        if (!Arrays.equals(this.getEnd(), other.getEnd())) {
            return false;
        }
        PartType this$type = this.getType();
        PartType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        CommonId this$leader = this.getLeader();
        CommonId other$leader = other.getLeader();
        if (this$leader == null ? other$leader != null : !((Object)this$leader).equals(other$leader)) {
            return false;
        }
        Location this$leaderLocation = this.getLeaderLocation();
        Location other$leaderLocation = other.getLeaderLocation();
        if (this$leaderLocation == null ? other$leaderLocation != null : !((Object)this$leaderLocation).equals(other$leaderLocation)) {
            return false;
        }
        List<CommonId> this$replicates = this.getReplicates();
        List<CommonId> other$replicates = other.getReplicates();
        if (this$replicates == null ? other$replicates != null : !((Object)this$replicates).equals(other$replicates)) {
            return false;
        }
        List<Location> this$replicateLocations = this.getReplicateLocations();
        List<Location> other$replicateLocations = other.getReplicateLocations();
        return !(this$replicateLocations == null ? other$replicateLocations != null : !((Object)this$replicateLocations).equals(other$replicateLocations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Part;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getTtl();
        CommonId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        CommonId $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
        CommonId $replicateId = this.getReplicateId();
        result = result * 59 + ($replicateId == null ? 43 : ((Object)$replicateId).hashCode());
        result = result * 59 + Arrays.hashCode(this.getStart());
        result = result * 59 + Arrays.hashCode(this.getEnd());
        PartType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        CommonId $leader = this.getLeader();
        result = result * 59 + ($leader == null ? 43 : ((Object)$leader).hashCode());
        Location $leaderLocation = this.getLeaderLocation();
        result = result * 59 + ($leaderLocation == null ? 43 : ((Object)$leaderLocation).hashCode());
        List<CommonId> $replicates = this.getReplicates();
        result = result * 59 + ($replicates == null ? 43 : ((Object)$replicates).hashCode());
        List<Location> $replicateLocations = this.getReplicateLocations();
        result = result * 59 + ($replicateLocations == null ? 43 : ((Object)$replicateLocations).hashCode());
        return result;
    }

    public static class PartBuilder {
        private CommonId id;
        private CommonId instanceId;
        private CommonId replicateId;
        private byte[] start;
        private byte[] end;
        private boolean type$set;
        private PartType type$value;
        private CommonId leader;
        private Location leaderLocation;
        private List<CommonId> replicates;
        private List<Location> replicateLocations;
        private int version;
        private int ttl;

        PartBuilder() {
        }

        public PartBuilder id(CommonId id) {
            this.id = id;
            return this;
        }

        public PartBuilder instanceId(CommonId instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public PartBuilder replicateId(CommonId replicateId) {
            this.replicateId = replicateId;
            return this;
        }

        public PartBuilder start(byte[] start) {
            this.start = start;
            return this;
        }

        public PartBuilder end(byte[] end) {
            this.end = end;
            return this;
        }

        public PartBuilder type(PartType type2) {
            this.type$value = type2;
            this.type$set = true;
            return this;
        }

        public PartBuilder leader(CommonId leader) {
            this.leader = leader;
            return this;
        }

        public PartBuilder leaderLocation(Location leaderLocation) {
            this.leaderLocation = leaderLocation;
            return this;
        }

        public PartBuilder replicates(List<CommonId> replicates) {
            this.replicates = replicates;
            return this;
        }

        public PartBuilder replicateLocations(List<Location> replicateLocations) {
            this.replicateLocations = replicateLocations;
            return this;
        }

        public PartBuilder version(int version) {
            this.version = version;
            return this;
        }

        public PartBuilder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Part build() {
            PartType type$value = this.type$value;
            if (!this.type$set) {
                type$value = Part.$default$type();
            }
            return new Part(this.id, this.instanceId, this.replicateId, this.start, this.end, type$value, this.leader, this.leaderLocation, this.replicates, this.replicateLocations, this.version, this.ttl);
        }

        public String toString() {
            return "Part.PartBuilder(id=" + this.id + ", instanceId=" + this.instanceId + ", replicateId=" + this.replicateId + ", start=" + Arrays.toString(this.start) + ", end=" + Arrays.toString(this.end) + ", type$value=" + (Object)((Object)this.type$value) + ", leader=" + this.leader + ", leaderLocation=" + this.leaderLocation + ", replicates=" + this.replicates + ", replicateLocations=" + this.replicateLocations + ", version=" + this.version + ", ttl=" + this.ttl + ")";
        }
    }

    public static enum PartType {
        ROW_STORE,
        COLUMN_STORE;

    }
}

