/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.table;

import io.dingodb.common.codec.AvroCodec;
import io.dingodb.common.codec.KeyValueCodec;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.TupleMapping;
import io.dingodb.common.type.converter.AvroConverter;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroKeyValueCodec
implements KeyValueCodec {
    private static final Logger log = LoggerFactory.getLogger(AvroKeyValueCodec.class);
    private final AvroCodec keyCodec;
    private final AvroCodec valueCodec;
    private final TupleMapping keyMapping;
    private final TupleMapping valueMapping;
    private final DingoType schema;

    public AvroKeyValueCodec(@Nonnull DingoType schema, @Nonnull TupleMapping keyMapping) {
        this.schema = schema;
        this.keyMapping = keyMapping;
        this.valueMapping = keyMapping.inverse(schema.fieldCount());
        this.keyCodec = new AvroCodec(schema.select(keyMapping).toAvroSchema());
        this.valueCodec = new AvroCodec(schema.select(this.valueMapping).toAvroSchema());
    }

    @Override
    public Object[] decode(@Nonnull KeyValue keyValue) throws IOException {
        Object[] result = new Object[this.keyMapping.size() + this.valueMapping.size()];
        this.keyCodec.decode(result, keyValue.getKey(), this.keyMapping);
        this.valueCodec.decode(result, keyValue.getValue(), this.valueMapping);
        return (Object[])this.schema.convertFrom(result, AvroConverter.INSTANCE);
    }

    @Override
    public Object[] decodeKey(@Nonnull byte[] bytes) throws IOException {
        Object[] result = new Object[this.keyMapping.size()];
        this.keyCodec.decode(result, bytes, this.keyMapping);
        return (Object[])this.schema.convertFrom(result, AvroConverter.INSTANCE);
    }

    @Override
    public KeyValue encode(@Nonnull Object[] tuple) throws IOException {
        Object[] converted = (Object[])this.schema.convertTo(tuple, AvroConverter.INSTANCE);
        return new KeyValue(this.keyCodec.encode(converted, this.keyMapping), this.valueCodec.encode(converted, this.valueMapping));
    }

    @Override
    public byte[] encodeKey(@Nonnull Object[] keys) throws IOException {
        return this.keyCodec.encode(keys);
    }

    @Override
    public Object[] mapKeyAndDecodeValue(@Nonnull Object[] keys, byte[] bytes) throws IOException {
        Object[] result = new Object[this.keyMapping.size() + this.valueMapping.size()];
        this.keyMapping.map(result, keys);
        this.valueCodec.decode(result, bytes, this.valueMapping);
        return (Object[])this.schema.convertFrom(result, AvroConverter.INSTANCE);
    }
}

