/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dingodb.common.table.PrecisionSerializer;
import io.dingodb.common.table.ScaleSerializer;
import io.dingodb.common.table.SqlTypeNameSerializer;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.DingoTypeFactory;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"name", "type", "precision", "scale", "nullable", "primary", "default"})
public class ColumnDefinition {
    private static final Logger log = LoggerFactory.getLogger(ColumnDefinition.class);
    @JsonProperty(value="name", required=true)
    private final String name;
    @JsonProperty(value="type", required=true)
    @JsonSerialize(using=SqlTypeNameSerializer.class)
    private final SqlTypeName type;
    @JsonProperty(value="elementType")
    @JsonSerialize(using=SqlTypeNameSerializer.class)
    private final SqlTypeName elementType;
    @JsonProperty(value="precision")
    @JsonSerialize(using=PrecisionSerializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final int precision;
    @JsonProperty(value="scale")
    @JsonSerialize(using=ScaleSerializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final int scale;
    @JsonProperty(value="notNull")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean notNull;
    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean primary;
    @JsonProperty(value="default")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final String defaultValue;

    @JsonCreator
    public static ColumnDefinition getInstance(@JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="type") String typeName, @JsonProperty(value="elementType") String elementTypeName, @JsonProperty(value="precision") Integer precision, @JsonProperty(value="scale") Integer scale, @JsonProperty(value="notNull") boolean notNull, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="default") String defaultValue) {
        SqlTypeName type2 = SqlTypeName.get(typeName.toUpperCase());
        if (type2 != null) {
            return ColumnDefinition.builder().name(name).type(type2).elementType(elementTypeName == null ? null : SqlTypeName.get(elementTypeName.toUpperCase())).precision(precision != null ? precision : -1).scale(scale != null ? scale : Integer.MIN_VALUE).notNull(notNull).primary(primary).defaultValue(defaultValue).build();
        }
        throw new AssertionError((Object)("Invalid type name \"" + typeName + "\"."));
    }

    public RelDataType getRelDataType(@NonNull RelDataTypeFactory typeFactory) {
        RelDataType relDataType;
        if (typeFactory == null) {
            throw new NullPointerException("typeFactory is marked non-null but is null");
        }
        switch (this.type) {
            case ARRAY: {
                relDataType = typeFactory.createArrayType(typeFactory.createSqlType(this.elementType), -1L);
                break;
            }
            case MULTISET: {
                relDataType = typeFactory.createMultisetType(typeFactory.createSqlType(this.elementType), -1L);
                break;
            }
            case MAP: {
                relDataType = typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.INTEGER));
                break;
            }
            default: {
                if (this.precision != -1) {
                    if (this.scale != Integer.MIN_VALUE) {
                        relDataType = typeFactory.createSqlType(this.type, this.precision, this.scale);
                        break;
                    }
                    relDataType = typeFactory.createSqlType(this.type, this.precision);
                    break;
                }
                relDataType = typeFactory.createSqlType(this.type);
            }
        }
        return typeFactory.createTypeWithNullability(relDataType, !this.notNull);
    }

    public DingoType getDingoType() {
        return DingoTypeFactory.fromColumnDefinition(this);
    }

    public ColumnStrategy getColumnStrategy() {
        if (this.defaultValue != null) {
            return ColumnStrategy.DEFAULT;
        }
        if (this.notNull) {
            return ColumnStrategy.NOT_NULLABLE;
        }
        return ColumnStrategy.NULLABLE;
    }

    private static int $default$precision() {
        return -1;
    }

    private static int $default$scale() {
        return Integer.MIN_VALUE;
    }

    private static boolean $default$notNull() {
        return false;
    }

    private static boolean $default$primary() {
        return false;
    }

    private static String $default$defaultValue() {
        return null;
    }

    ColumnDefinition(String name, SqlTypeName type2, SqlTypeName elementType, int precision, int scale, boolean notNull, boolean primary, String defaultValue) {
        this.name = name;
        this.type = type2;
        this.elementType = elementType;
        this.precision = precision;
        this.scale = scale;
        this.notNull = notNull;
        this.primary = primary;
        this.defaultValue = defaultValue;
    }

    public static ColumnDefinitionBuilder builder() {
        return new ColumnDefinitionBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPrecision() != other.getPrecision()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        if (this.isNotNull() != other.isNotNull()) {
            return false;
        }
        if (this.isPrimary() != other.isPrimary()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SqlTypeName this$type = this.getType();
        SqlTypeName other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        SqlTypeName this$elementType = this.getElementType();
        SqlTypeName other$elementType = other.getElementType();
        if (this$elementType == null ? other$elementType != null : !((Object)((Object)this$elementType)).equals((Object)other$elementType)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPrecision();
        result = result * 59 + this.getScale();
        result = result * 59 + (this.isNotNull() ? 79 : 97);
        result = result * 59 + (this.isPrimary() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SqlTypeName $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        SqlTypeName $elementType = this.getElementType();
        result = result * 59 + ($elementType == null ? 43 : ((Object)((Object)$elementType)).hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public SqlTypeName getType() {
        return this.type;
    }

    public SqlTypeName getElementType() {
        return this.elementType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public static class ColumnDefinitionBuilder {
        private String name;
        private SqlTypeName type;
        private SqlTypeName elementType;
        private boolean precision$set;
        private int precision$value;
        private boolean scale$set;
        private int scale$value;
        private boolean notNull$set;
        private boolean notNull$value;
        private boolean primary$set;
        private boolean primary$value;
        private boolean defaultValue$set;
        private String defaultValue$value;

        ColumnDefinitionBuilder() {
        }

        @JsonProperty(value="name", required=true)
        public ColumnDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type", required=true)
        public ColumnDefinitionBuilder type(SqlTypeName type2) {
            this.type = type2;
            return this;
        }

        @JsonProperty(value="elementType")
        public ColumnDefinitionBuilder elementType(SqlTypeName elementType) {
            this.elementType = elementType;
            return this;
        }

        @JsonProperty(value="precision")
        public ColumnDefinitionBuilder precision(int precision) {
            this.precision$value = precision;
            this.precision$set = true;
            return this;
        }

        @JsonProperty(value="scale")
        public ColumnDefinitionBuilder scale(int scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return this;
        }

        @JsonProperty(value="notNull")
        public ColumnDefinitionBuilder notNull(boolean notNull) {
            this.notNull$value = notNull;
            this.notNull$set = true;
            return this;
        }

        @JsonProperty(value="primary")
        public ColumnDefinitionBuilder primary(boolean primary) {
            this.primary$value = primary;
            this.primary$set = true;
            return this;
        }

        @JsonProperty(value="default")
        public ColumnDefinitionBuilder defaultValue(String defaultValue) {
            this.defaultValue$value = defaultValue;
            this.defaultValue$set = true;
            return this;
        }

        public ColumnDefinition build() {
            int precision$value = this.precision$value;
            if (!this.precision$set) {
                precision$value = ColumnDefinition.$default$precision();
            }
            int scale$value = this.scale$value;
            if (!this.scale$set) {
                scale$value = ColumnDefinition.$default$scale();
            }
            boolean notNull$value = this.notNull$value;
            if (!this.notNull$set) {
                notNull$value = ColumnDefinition.$default$notNull();
            }
            boolean primary$value = this.primary$value;
            if (!this.primary$set) {
                primary$value = ColumnDefinition.$default$primary();
            }
            String defaultValue$value = this.defaultValue$value;
            if (!this.defaultValue$set) {
                defaultValue$value = ColumnDefinition.$default$defaultValue();
            }
            return new ColumnDefinition(this.name, this.type, this.elementType, precision$value, scale$value, notNull$value, primary$value, defaultValue$value);
        }

        public String toString() {
            return "ColumnDefinition.ColumnDefinitionBuilder(name=" + this.name + ", type=" + (Object)((Object)this.type) + ", elementType=" + (Object)((Object)this.elementType) + ", precision$value=" + this.precision$value + ", scale$value=" + this.scale$value + ", notNull$value=" + this.notNull$value + ", primary$value=" + this.primary$value + ", defaultValue$value=" + this.defaultValue$value + ")";
        }
    }
}

