/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.table;

import io.dingodb.common.codec.Codec;
import io.dingodb.common.codec.DingoCodec;
import io.dingodb.common.codec.KeyValueCodec;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.TupleMapping;
import io.dingodb.common.type.converter.DingoConverter;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoKeyValueCodec
implements KeyValueCodec {
    private static final Logger log = LoggerFactory.getLogger(DingoKeyValueCodec.class);
    private final DingoType schema;
    private final DingoType keySchema;
    TupleMapping keyMapping;
    TupleMapping valueMapping;
    Codec keyCodec;
    Codec valueCodec;

    public DingoKeyValueCodec(@Nonnull DingoType schema, @Nonnull TupleMapping keyMapping) {
        this.schema = schema;
        this.keySchema = schema.select(keyMapping);
        this.keyMapping = keyMapping;
        this.valueMapping = keyMapping.inverse(schema.fieldCount());
        this.keyCodec = new DingoCodec(schema.select(keyMapping).toDingoSchemas(), keyMapping, true);
        this.valueCodec = new DingoCodec(schema.select(this.valueMapping).toDingoSchemas(), this.valueMapping, false);
    }

    @Override
    public Object[] decode(@Nonnull KeyValue keyValue) throws IOException {
        int i;
        Object[] record = new Object[this.keyMapping.size() + this.valueMapping.size()];
        Object[] key = this.keyCodec.decodeKey(keyValue.getKey());
        Object[] value = this.valueCodec.decode(keyValue.getValue());
        for (i = 0; i < key.length; ++i) {
            record[this.keyMapping.get((int)i)] = key[i];
        }
        for (i = 0; i < value.length; ++i) {
            record[this.valueMapping.get((int)i)] = value[i];
        }
        return (Object[])this.schema.convertFrom(record, DingoConverter.INSTANCE);
    }

    @Override
    public Object[] decodeKey(@Nonnull byte[] bytes) throws IOException {
        return this.keyCodec.decodeKey(bytes);
    }

    @Override
    public KeyValue encode(@Nonnull Object[] tuple) throws IOException {
        int i;
        Object[] converted = (Object[])this.schema.convertTo(tuple, DingoConverter.INSTANCE);
        Object[] key = new Object[this.keyMapping.size()];
        Object[] value = new Object[this.valueMapping.size()];
        for (i = 0; i < this.keyMapping.size(); ++i) {
            key[i] = converted[this.keyMapping.get(i)];
        }
        for (i = 0; i < this.valueMapping.size(); ++i) {
            value[i] = converted[this.valueMapping.get(i)];
        }
        byte[] keyByte = this.keyCodec.encodeKey(key);
        byte[] valueByte = this.valueCodec.encode(value);
        return new KeyValue(keyByte, valueByte);
    }

    @Override
    public byte[] encodeKey(@Nonnull Object[] keys) throws IOException {
        Object[] key = (Object[])this.keySchema.convertTo(keys, DingoConverter.INSTANCE);
        return this.keyCodec.encodeKey(key);
    }

    @Override
    public Object[] mapKeyAndDecodeValue(@Nonnull Object[] keys, byte[] bytes) throws IOException {
        int i;
        Object[] value = this.valueCodec.decode(bytes);
        Object[] record = new Object[this.keyMapping.size() + this.valueMapping.size()];
        for (i = 0; i < keys.length; ++i) {
            record[this.keyMapping.get((int)i)] = keys[i];
        }
        for (i = 0; i < value.length; ++i) {
            record[this.valueMapping.get((int)i)] = value[i];
        }
        return (Object[])this.schema.convertFrom(record, DingoConverter.INSTANCE);
    }
}

