/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.dingodb.common.partition.DingoTablePart;
import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.DingoTypeFactory;
import io.dingodb.common.type.TupleMapping;
import io.dingodb.expr.json.runtime.Parser;
import io.dingodb.serial.schema.DingoSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ColumnStrategy;

@JsonPropertyOrder(value={"name", "columns"})
public class TableDefinition {
    private static final Parser PARSER = Parser.JSON;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="columns")
    private List<ColumnDefinition> columns;
    private String partType;
    private Map<String, Object> attrMap;
    private DingoTablePart dingoTablePart;

    public String getName() {
        return this.name.toUpperCase();
    }

    @JsonCreator
    public TableDefinition(@JsonProperty(value="name") String name) {
        this.name = name;
    }

    public String getPartType() {
        return this.partType;
    }

    public void setPartType(String partType) {
        this.partType = partType;
    }

    public Map<String, Object> getAttrMap() {
        return this.attrMap;
    }

    public void setAttrMap(Map<String, Object> attrMap) {
        this.attrMap = attrMap;
    }

    public DingoTablePart getDingoTablePart() {
        return this.dingoTablePart;
    }

    public void setDingoTablePart(DingoTablePart dingoTablePart) {
        this.dingoTablePart = dingoTablePart;
    }

    public static TableDefinition fromJson(String json) throws IOException {
        return PARSER.parse(json, TableDefinition.class);
    }

    public static TableDefinition readJson(InputStream is) throws IOException {
        return PARSER.parse(is, TableDefinition.class);
    }

    public TableDefinition addColumn(ColumnDefinition column) {
        if (this.columns == null) {
            this.columns = new LinkedList<ColumnDefinition>();
        }
        this.columns.add(column);
        return this;
    }

    public ColumnDefinition getColumn(int index) {
        return this.columns.get(index);
    }

    @Nullable
    public ColumnDefinition getColumn(String name) {
        for (ColumnDefinition column : this.columns) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    public int getColumnIndexOfValue(String name) {
        return this.getColumnIndex(name) - this.getPrimaryKeyCount();
    }

    public int getColumnIndex(String name) {
        int i = 0;
        for (ColumnDefinition column : this.columns) {
            if (column.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getColumnIndices(@Nonnull List<String> names) {
        int[] indices = new int[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            indices[i] = this.getColumnIndex(names.get(i));
        }
        return indices;
    }

    public int getPrimaryKeyCount() {
        int count = 0;
        for (ColumnDefinition column : this.columns) {
            if (!column.isPrimary()) continue;
            ++count;
        }
        return count;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public RelDataType getRelDataType(@Nonnull RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType(this.columns.stream().map(c -> c.getRelDataType(typeFactory)).collect(Collectors.toList()), this.columns.stream().map(ColumnDefinition::getName).map(String::toUpperCase).collect(Collectors.toList()));
    }

    public TupleMapping getKeyMapping() {
        return this.getColumnMapping(true);
    }

    public TupleMapping getRevKeyMapping() {
        return this.getKeyMapping().reverse(this.getColumnsCount());
    }

    public TupleMapping getValueMapping() {
        return this.getColumnMapping(false);
    }

    public TupleMapping getMapping() {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int index = 0;
        for (ColumnDefinition column : this.columns) {
            indices.add(index);
            ++index;
        }
        return TupleMapping.of(indices);
    }

    public int getFirstPrimaryColumnIndex() {
        int index = 0;
        for (ColumnDefinition column : this.columns) {
            if (column.isPrimary()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Nonnull
    private TupleMapping getColumnMapping(boolean keyOrValue) {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int index = 0;
        for (ColumnDefinition column : this.columns) {
            if (column.isPrimary() == keyOrValue) {
                indices.add(index);
            }
            ++index;
        }
        return TupleMapping.of(indices);
    }

    public List<DingoSchema> getDingoSchemaOfKey() {
        ArrayList<DingoSchema> keySchema = new ArrayList<DingoSchema>();
        int index = 0;
        for (ColumnDefinition column : this.columns) {
            if (!column.isPrimary()) continue;
            keySchema.add(column.getDingoType().toDingoSchema(index++));
        }
        return keySchema;
    }

    public List<DingoSchema> getDingoSchemaOfValue() {
        ArrayList<DingoSchema> valueSchema = new ArrayList<DingoSchema>();
        int index = 0;
        for (ColumnDefinition column : this.columns) {
            if (column.isPrimary()) continue;
            valueSchema.add(column.getDingoType().toDingoSchema(index++));
        }
        return valueSchema;
    }

    public List<DingoSchema> getDingoSchema() {
        ArrayList<DingoSchema> schema = new ArrayList<DingoSchema>();
        for (int i = 0; i < this.columns.size(); ++i) {
            schema.add(this.columns.get(i).getDingoType().toDingoSchema(i));
        }
        return schema;
    }

    @Nonnull
    public DingoType getDingoType() {
        return DingoTypeFactory.tuple((DingoType[])this.columns.stream().map(ColumnDefinition::getDingoType).toArray(DingoType[]::new));
    }

    @Nonnull
    public DingoType getDingoType(boolean keyOrValue) {
        return DingoTypeFactory.tuple((DingoType[])this.getColumnMapping(keyOrValue).stream().mapToObj(this.columns::get).map(ColumnDefinition::getDingoType).toArray(DingoType[]::new));
    }

    public ColumnStrategy getColumnStrategy(int index) {
        return this.columns.get(index).getColumnStrategy();
    }

    public String toJson() throws JsonProcessingException {
        return PARSER.stringify(this);
    }

    public void writeJson(OutputStream os) throws IOException {
        PARSER.writeStream(os, this);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDefinition)) {
            return false;
        }
        TableDefinition other = (TableDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ColumnDefinition> this$columns = this.getColumns();
        List<ColumnDefinition> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$partType = this.getPartType();
        String other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        Map<String, Object> this$attrMap = this.getAttrMap();
        Map<String, Object> other$attrMap = other.getAttrMap();
        if (this$attrMap == null ? other$attrMap != null : !((Object)this$attrMap).equals(other$attrMap)) {
            return false;
        }
        DingoTablePart this$dingoTablePart = this.getDingoTablePart();
        DingoTablePart other$dingoTablePart = other.getDingoTablePart();
        return !(this$dingoTablePart == null ? other$dingoTablePart != null : !this$dingoTablePart.equals(other$dingoTablePart));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ColumnDefinition> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 43 : $partType.hashCode());
        Map<String, Object> $attrMap = this.getAttrMap();
        result = result * 59 + ($attrMap == null ? 43 : ((Object)$attrMap).hashCode());
        DingoTablePart $dingoTablePart = this.getDingoTablePart();
        result = result * 59 + ($dingoTablePart == null ? 43 : $dingoTablePart.hashCode());
        return result;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }
}

