/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.TupleMapping;
import io.dingodb.common.type.converter.CsvConverter;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.expr.runtime.TypeCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractDingoType
implements DingoType {
    protected int typeCode;
    private Integer id;

    public AbstractDingoType() {
    }

    protected AbstractDingoType(int typeCode) {
        this.typeCode = typeCode;
    }

    protected abstract Object convertValueTo(@Nonnull Object var1, @Nonnull DataConverter var2);

    protected abstract Object convertValueFrom(@Nonnull Object var1, @Nonnull DataConverter var2);

    @Override
    public int fieldCount() {
        return 0;
    }

    @Override
    public DingoType getChild(@Nonnull Object index) {
        throw new IllegalStateException("Get child of type \"" + TypeCode.nameOf(this.typeCode) + "\" is stupid.");
    }

    @Override
    public DingoType select(@Nonnull TupleMapping mapping) {
        throw new IllegalStateException("Selecting fields from type \"" + TypeCode.nameOf(this.typeCode) + "\" is stupid.");
    }

    @Override
    public Object convertTo(@Nullable Object value, @Nonnull DataConverter converter) {
        if (value != null) {
            return this.convertValueTo(value, converter);
        }
        return null;
    }

    @Override
    public Object convertFrom(@Nullable Object value, @Nonnull DataConverter converter) {
        if (value != null && !converter.isNull(value)) {
            return this.convertValueFrom(value, converter);
        }
        return null;
    }

    @Override
    public Object parse(@Nullable Object value) {
        return this.convertFrom(value, CsvConverter.INSTANCE);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDingoType)) {
            return false;
        }
        AbstractDingoType other = (AbstractDingoType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getTypeCode() == other.getTypeCode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDingoType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTypeCode();
        return result;
    }

    @Override
    public int getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }
}

