/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.NullType;
import io.dingodb.common.type.NullableType;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.serial.schema.DingoSchema;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

@JsonTypeName(value="array")
@JsonPropertyOrder(value={"element", "nullable"})
public class ArrayType
extends NullableType {
    @JsonProperty(value="element")
    private final DingoType elementType;

    @JsonCreator
    ArrayType(@JsonProperty(value="element") DingoType elementType, @JsonProperty(value="nullable") boolean nullable) {
        super(183594037, nullable);
        this.elementType = elementType;
    }

    @Override
    protected Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convert((Object[])value, this.elementType);
    }

    @Override
    protected Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convertArrayFrom(value, this.elementType);
    }

    @Override
    public DingoType copy() {
        return new ArrayType(this.elementType, this.nullable);
    }

    @Override
    public List<DingoSchema> toDingoSchemas() {
        return null;
    }

    @Override
    public DingoSchema toDingoSchema(int index) {
        return null;
    }

    @Override
    public String format(@Nullable Object value) {
        if (value != null) {
            Object[] arr = (Object[])value;
            StringBuilder b = new StringBuilder();
            b.append("[ ");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.elementType.format(arr[i]));
            }
            b.append(" ]");
            return b.toString();
        }
        return NullType.NULL.format(null);
    }

    @Override
    protected Schema toAvroSchemaNotNull() {
        return Schema.createArray(this.elementType.toAvroSchema());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("array(");
        b.append(this.elementType.toString());
        b.append(")");
        if (this.nullable) {
            b.append("|").append(NullType.NULL);
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DingoType this$elementType = this.elementType;
        DingoType other$elementType = other.elementType;
        return !(this$elementType == null ? other$elementType != null : !this$elementType.equals(other$elementType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArrayType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DingoType $elementType = this.elementType;
        result = result * 59 + ($elementType == null ? 43 : $elementType.hashCode());
        return result;
    }
}

