/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import io.dingodb.common.table.ColumnDefinition;
import io.dingodb.common.type.ArrayType;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.ListType;
import io.dingodb.common.type.MapType;
import io.dingodb.common.type.NullType;
import io.dingodb.common.type.TupleType;
import io.dingodb.common.type.scalar.AbstractScalarType;
import io.dingodb.common.type.scalar.BinaryType;
import io.dingodb.common.type.scalar.BooleanType;
import io.dingodb.common.type.scalar.DateType;
import io.dingodb.common.type.scalar.DecimalType;
import io.dingodb.common.type.scalar.DoubleType;
import io.dingodb.common.type.scalar.IntegerType;
import io.dingodb.common.type.scalar.LongType;
import io.dingodb.common.type.scalar.ObjectType;
import io.dingodb.common.type.scalar.StringType;
import io.dingodb.common.type.scalar.TimeType;
import io.dingodb.common.type.scalar.TimestampType;
import io.dingodb.expr.runtime.TypeCode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DingoTypeFactory {
    private static final Logger log = LoggerFactory.getLogger(DingoTypeFactory.class);

    private DingoTypeFactory() {
    }

    @Nonnull
    public static AbstractScalarType scalar(int typeCode, boolean nullable) {
        switch (typeCode) {
            case -2056817302: {
                return new IntegerType(nullable);
            }
            case 1195259493: {
                return new StringType(nullable);
            }
            case 344809556: {
                return new BooleanType(nullable);
            }
            case 398795216: {
                return new LongType(nullable);
            }
            case 761287205: {
                return new DoubleType(nullable);
            }
            case -1405464277: {
                return new DecimalType(nullable);
            }
            case 1087757882: {
                return new DateType(nullable);
            }
            case 1088242009: {
                return new TimeType(nullable);
            }
            case 1252880906: {
                return new TimestampType(nullable);
            }
            case -1374008726: {
                return new BinaryType(nullable);
            }
            case 1063877011: {
                return new ObjectType(nullable);
            }
        }
        throw new IllegalArgumentException("Cannot create scalar type \"" + TypeCode.nameOf(typeCode) + "\".");
    }

    @Nonnull
    public static AbstractScalarType scalar(@Nonnull String typeString) {
        String[] v = typeString.split("\\|", 2);
        boolean nullable = v.length > 1 && v[1].equals(NullType.NULL.toString());
        return DingoTypeFactory.scalar(TypeCode.codeOf(v[0]), nullable);
    }

    @Nonnull
    public static AbstractScalarType scalar(int typeCode) {
        return DingoTypeFactory.scalar(typeCode, false);
    }

    @Nonnull
    public static TupleType tuple(DingoType[] fields) {
        return new TupleType(fields);
    }

    @Nonnull
    public static TupleType tuple(String ... types) {
        return DingoTypeFactory.tuple((DingoType[])Arrays.stream(types).map(DingoTypeFactory::scalar).toArray(DingoType[]::new));
    }

    @Nonnull
    public static TupleType tuple(int ... typeCodes) {
        return DingoTypeFactory.tuple((DingoType[])Arrays.stream(typeCodes).mapToObj(DingoTypeFactory::scalar).toArray(DingoType[]::new));
    }

    @Nonnull
    public static ArrayType array(DingoType elementType, boolean nullable) {
        return new ArrayType(elementType, nullable);
    }

    @Nonnull
    public static ArrayType array(int elementTypeCode, boolean nullable) {
        return DingoTypeFactory.array(DingoTypeFactory.scalar(elementTypeCode, false), nullable);
    }

    @Nonnull
    public static ArrayType array(String type2, boolean nullable) {
        return DingoTypeFactory.array(DingoTypeFactory.scalar(type2), nullable);
    }

    @Nonnull
    public static ListType list(DingoType elementType, boolean nullable) {
        return new ListType(elementType, nullable);
    }

    @Nonnull
    public static ListType list(int elementTypeCode, boolean nullable) {
        return DingoTypeFactory.list(DingoTypeFactory.scalar(elementTypeCode, false), nullable);
    }

    @Nonnull
    public static ListType list(String type2, boolean nullable) {
        return DingoTypeFactory.list(DingoTypeFactory.scalar(type2), nullable);
    }

    @Nonnull
    public static MapType map(DingoType keyType, DingoType valueType, boolean nullable) {
        return new MapType(keyType, valueType, nullable);
    }

    @Nonnull
    public static MapType map(int keyTypeCode, int valueTypeCode, boolean nullable) {
        return DingoTypeFactory.map(DingoTypeFactory.scalar(keyTypeCode, false), DingoTypeFactory.scalar(valueTypeCode, false), nullable);
    }

    @Nonnull
    public static MapType map(String keyType, String valueType, boolean nullable) {
        return DingoTypeFactory.map(DingoTypeFactory.scalar(keyType), DingoTypeFactory.scalar(valueType), nullable);
    }

    @Nonnull
    public static DingoType fromColumnDefinition(@Nonnull ColumnDefinition columnDefinition) {
        SqlTypeName type2 = columnDefinition.getType();
        boolean notNull = columnDefinition.isNotNull();
        switch (type2) {
            case ARRAY: 
            case MULTISET: {
                SqlTypeName elementType = columnDefinition.getElementType();
                if (log.isDebugEnabled()) {
                    log.debug("current type is:{}, elementType is:{}, definition:{}", new Object[]{type2, elementType, columnDefinition});
                }
                return DingoTypeFactory.list(TypeCode.codeOf(elementType.getName()), !notNull);
            }
        }
        return DingoTypeFactory.scalar(TypeCode.codeOf(type2.getName()), !notNull);
    }

    @Nonnull
    public static DingoType fromRelDataType(@Nonnull RelDataType relDataType) {
        if (!relDataType.isStruct()) {
            SqlTypeName sqlTypeName = relDataType.getSqlTypeName();
            switch (sqlTypeName) {
                case NULL: {
                    return NullType.NULL;
                }
                case ARRAY: 
                case MULTISET: {
                    DingoType elementType = DingoTypeFactory.fromRelDataType(Objects.requireNonNull(relDataType.getComponentType()));
                    return DingoTypeFactory.list(elementType, relDataType.isNullable());
                }
                case MAP: {
                    DingoType keyType = DingoTypeFactory.fromRelDataType(Objects.requireNonNull(relDataType.getKeyType()));
                    DingoType valueType = DingoTypeFactory.fromRelDataType(Objects.requireNonNull(relDataType.getValueType()));
                    return DingoTypeFactory.map(keyType, valueType, relDataType.isNullable());
                }
            }
            return DingoTypeFactory.scalar(TypeCode.codeOf(relDataType.getSqlTypeName().getName()), relDataType.isNullable());
        }
        return DingoTypeFactory.tuple((DingoType[])relDataType.getFieldList().stream().map(RelDataTypeField::getType).map(DingoTypeFactory::fromRelDataType).toArray(DingoType[]::new));
    }

    @Nonnull
    private static DingoType fromAvaticaType(ColumnMetaData.AvaticaType avaticaType) {
        if (avaticaType instanceof ColumnMetaData.ScalarType) {
            return DingoTypeFactory.scalar(DingoTypeFactory.convertSqlTypeId(avaticaType.id), false);
        }
        if (avaticaType instanceof ColumnMetaData.ArrayType) {
            ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)avaticaType;
            return DingoTypeFactory.list(DingoTypeFactory.fromAvaticaType(arrayType.getComponent()), false);
        }
        if (avaticaType instanceof ColumnMetaData.StructType) {
            ColumnMetaData.StructType structType = (ColumnMetaData.StructType)avaticaType;
            return DingoTypeFactory.fromColumnMetaDataList(structType.columns);
        }
        throw new IllegalStateException("Unsupported avatica type \"" + avaticaType + "\".");
    }

    @Nonnull
    public static DingoType fromColumnMetaData(@Nonnull ColumnMetaData colMeta) {
        switch (colMeta.type.id) {
            case 2003: {
                ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)colMeta.type;
                return DingoTypeFactory.list(DingoTypeFactory.fromAvaticaType(arrayType.getComponent()), colMeta.nullable != 0);
            }
            case 2002: {
                ColumnMetaData.StructType structType = (ColumnMetaData.StructType)colMeta.type;
                return DingoTypeFactory.fromColumnMetaDataList(structType.columns);
            }
        }
        return DingoTypeFactory.scalar(DingoTypeFactory.convertSqlTypeId(colMeta.type.id), colMeta.nullable != 0);
    }

    @Nonnull
    public static TupleType fromColumnMetaDataList(@Nonnull List<ColumnMetaData> colMetaList) {
        return DingoTypeFactory.tuple((DingoType[])colMetaList.stream().map(DingoTypeFactory::fromColumnMetaData).toArray(DingoType[]::new));
    }

    private static int convertSqlTypeId(int typeId) {
        switch (typeId) {
            case 4: {
                return -2056817302;
            }
            case -5: {
                return 398795216;
            }
            case 6: 
            case 7: 
            case 8: {
                return 761287205;
            }
            case 16: {
                return 344809556;
            }
            case 3: {
                return -1405464277;
            }
            case 1: 
            case 12: {
                return 1195259493;
            }
            case 91: {
                return 1087757882;
            }
            case 92: {
                return 1088242009;
            }
            case 93: {
                return 1252880906;
            }
            case -2: {
                return -1374008726;
            }
            case 2000: {
                return 1063877011;
            }
        }
        throw new IllegalArgumentException("Unsupported sql type id \"" + typeId + "\".");
    }
}

