/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.NullType;
import io.dingodb.common.type.NullableType;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.common.util.TypeUtils;
import io.dingodb.serial.schema.DingoSchema;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

@JsonTypeName(value="list")
@JsonPropertyOrder(value={"element", "nullable"})
public class ListType
extends NullableType {
    @JsonProperty(value="element")
    private final DingoType elementType;

    @JsonCreator
    ListType(@JsonProperty(value="element") DingoType elementType, @JsonProperty(value="nullable") boolean nullable) {
        super(65821278, nullable);
        this.elementType = elementType;
    }

    @Override
    protected Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convert((List)value, this.elementType);
    }

    @Override
    protected Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convertListFrom(value, this.elementType);
    }

    @Override
    public DingoType copy() {
        return new ListType(this.elementType, this.nullable);
    }

    @Override
    public List<DingoSchema> toDingoSchemas() {
        return null;
    }

    @Override
    public DingoSchema toDingoSchema(int index) {
        DingoSchema schema = TypeUtils.elementTypeToDingoList(this.elementType);
        schema.setIndex(index);
        return schema;
    }

    @Override
    public String format(@Nullable Object value) {
        if (value != null) {
            List list = (List)value;
            StringBuilder b = new StringBuilder();
            b.append("[ ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.elementType.format(list.get(i)));
            }
            b.append(" ]");
            return b.toString();
        }
        return NullType.NULL.format(null);
    }

    @Override
    protected Schema toAvroSchemaNotNull() {
        return Schema.createArray(this.elementType.toAvroSchema());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("list(");
        b.append(this.elementType.toString());
        b.append(")");
        if (this.nullable) {
            b.append("|").append(NullType.NULL);
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListType)) {
            return false;
        }
        ListType other = (ListType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DingoType this$elementType = this.elementType;
        DingoType other$elementType = other.elementType;
        return !(this$elementType == null ? other$elementType != null : !this$elementType.equals(other$elementType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DingoType $elementType = this.elementType;
        result = result * 59 + ($elementType == null ? 43 : $elementType.hashCode());
        return result;
    }
}

