/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.NullType;
import io.dingodb.common.type.NullableType;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.serial.schema.DingoSchema;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

@JsonTypeName(value="map")
@JsonPropertyOrder(value={"element", "nullable"})
public class MapType
extends NullableType {
    @JsonProperty(value="key")
    private final DingoType keyType;
    @JsonProperty(value="value")
    private final DingoType valueType;

    @JsonCreator
    MapType(@JsonProperty(value="key") DingoType keyType, @JsonProperty(value="value") DingoType valueType, @JsonProperty(value="nullable") boolean nullable) {
        super(-1383349348, nullable);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convert((Map)value, this.keyType, this.valueType);
    }

    @Override
    protected Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convertMapFrom(value, this.keyType, this.valueType);
    }

    @Override
    public DingoType copy() {
        return new MapType(this.keyType, this.valueType, this.nullable);
    }

    @Override
    public List<DingoSchema> toDingoSchemas() {
        return null;
    }

    @Override
    public DingoSchema toDingoSchema(int index) {
        return null;
    }

    @Override
    public String format(@Nullable Object value) {
        if (value != null) {
            Map map = (Map)value;
            StringBuilder b = new StringBuilder();
            b.append("[ ");
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(entry.getKey());
                b.append(": ");
                b.append(entry.getValue());
                ++i;
            }
            b.append(" ]");
            return b.toString();
        }
        return NullType.NULL.format(null);
    }

    @Override
    protected Schema toAvroSchemaNotNull() {
        return Schema.createMap(this.valueType.toAvroSchema());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("map(");
        b.append(this.keyType.toString());
        b.append(", ");
        b.append(this.valueType.toString());
        b.append(")");
        if (this.nullable) {
            b.append("|").append(NullType.NULL);
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapType)) {
            return false;
        }
        MapType other = (MapType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DingoType this$keyType = this.keyType;
        DingoType other$keyType = other.keyType;
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
            return false;
        }
        DingoType this$valueType = this.valueType;
        DingoType other$valueType = other.valueType;
        return !(this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MapType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DingoType $keyType = this.keyType;
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        DingoType $valueType = this.valueType;
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        return result;
    }
}

