/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dingodb.common.type.AbstractDingoType;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;

public abstract class NullableType
extends AbstractDingoType {
    protected final boolean nullable;

    protected NullableType(int typeCode, boolean nullable) {
        super(typeCode);
        this.nullable = nullable;
    }

    @Override
    @Nonnull
    public Schema toAvroSchema() {
        Schema schema = this.toAvroSchemaNotNull();
        if (this.nullable) {
            return Schema.createUnion(schema, Schema.create(Schema.Type.NULL));
        }
        return schema;
    }

    protected abstract Schema toAvroSchemaNotNull();

    @JsonProperty(value="nullable", defaultValue="false")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NullableType)) {
            return false;
        }
        NullableType other = (NullableType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isNullable() == other.isNullable();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NullableType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isNullable() ? 79 : 97);
        return result;
    }
}

