/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.dingodb.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class TupleMapping {
    @Nonnull
    @JsonValue
    private final int[] mappings;

    private TupleMapping(@Nonnull int[] mappings) {
        this.mappings = mappings;
    }

    @JsonCreator
    @Nonnull
    public static TupleMapping of(int[] mappings) {
        return new TupleMapping(mappings);
    }

    @Nonnull
    public static TupleMapping of(@Nonnull List<Integer> intList) {
        int[] intArray = new int[intList.size()];
        int i = 0;
        for (Integer integer : intList) {
            intArray[i] = integer;
            ++i;
        }
        return new TupleMapping(intArray);
    }

    public int size() {
        return this.mappings.length;
    }

    public int get(int index) {
        return this.mappings[index];
    }

    @Nonnull
    public IntStream stream() {
        return Arrays.stream(this.mappings);
    }

    @Nonnull
    public TupleMapping reverse(int num) {
        if (num < 0) {
            num = Utils.max(this.mappings);
        }
        int[] result = new int[num];
        Arrays.fill(result, -1);
        for (int i = 0; i < this.mappings.length; ++i) {
            result[this.mappings[i]] = i;
        }
        return new TupleMapping(result);
    }

    public boolean contains(int index) {
        for (int i : this.mappings) {
            if (i != index) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public TupleMapping inverse(int num) {
        int[] result = new int[num - this.mappings.length];
        int j = 0;
        for (int i = 0; i < num; ++i) {
            if (this.contains(i)) continue;
            result[j++] = i;
        }
        return new TupleMapping(result);
    }

    public <T> void map(@Nonnull T[] dst, @Nonnull T[] src) {
        for (int i = 0; i < this.mappings.length; ++i) {
            dst[this.mappings[i]] = src[i];
        }
    }

    public <T> void map(@Nonnull T[] dst, @Nonnull T[] src, Function<T, T> cloneFunc) {
        for (int i = 0; i < this.mappings.length; ++i) {
            dst[this.mappings[i]] = cloneFunc.apply(src[i]);
        }
    }

    public <T> void revMap(@Nonnull T[] dst, @Nonnull T[] src) {
        for (int i = 0; i < this.mappings.length; ++i) {
            dst[i] = src[this.mappings[i]];
        }
    }

    public <T> void revMap(@Nonnull T[] dst, @Nonnull T[] src, Function<T, T> cloneFunc) {
        for (int i = 0; i < this.mappings.length; ++i) {
            dst[i] = cloneFunc.apply(src[this.mappings[i]]);
        }
    }

    @Nonnull
    public Object[] revMap(Object[] src) {
        Object[] dst = new Object[this.mappings.length];
        this.revMap(dst, src);
        return dst;
    }

    @Nonnull
    public String toString() {
        return Arrays.toString(this.mappings);
    }

    @Nonnull
    public int[] getMappings() {
        return this.mappings;
    }
}

