/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.type.AbstractDingoType;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.NullType;
import io.dingodb.common.type.TupleMapping;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.serial.schema.DingoSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

@JsonTypeName(value="tuple")
public class TupleType
extends AbstractDingoType {
    @JsonProperty(value="fields")
    private final DingoType[] fields;

    @JsonCreator
    TupleType(@JsonProperty(value="fields") DingoType[] fields) {
        super(110725064);
        this.fields = fields;
        this.setElementIds();
    }

    private void setElementIds() {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setId(i);
        }
    }

    @Override
    public Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        Object[] tuple = (Object[])value;
        this.checkFieldCount(tuple);
        return converter.collectTuple(IntStream.range(0, tuple.length).mapToObj(i -> this.fields[i].convertTo(tuple[i], converter)));
    }

    @Override
    public Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        return this.checkFieldCount(converter.convertTupleFrom(value, this));
    }

    @Override
    public int fieldCount() {
        return this.fields.length;
    }

    @Override
    public DingoType getChild(@Nonnull Object index) {
        return this.fields[(Integer)index];
    }

    @Override
    public TupleType select(@Nonnull TupleMapping mapping) {
        DingoType[] newElements = new DingoType[mapping.size()];
        mapping.revMap(newElements, this.fields, DingoType::copy);
        return new TupleType(newElements);
    }

    @Override
    public DingoType copy() {
        return new TupleType((DingoType[])Arrays.stream(this.fields).map(DingoType::copy).toArray(DingoType[]::new));
    }

    @Override
    @Nonnull
    public Schema toAvroSchema() {
        return Schema.createRecord(this.getClass().getSimpleName(), null, this.getClass().getPackage().getName(), false, IntStream.range(0, this.fields.length).mapToObj(i -> new Schema.Field("_" + i, this.fields[i].toAvroSchema())).collect(Collectors.toList()));
    }

    @Override
    public List<DingoSchema> toDingoSchemas() {
        ArrayList<DingoSchema> schemas = new ArrayList<DingoSchema>(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            schemas.add(this.fields[i].toDingoSchema(i));
        }
        return schemas;
    }

    @Override
    public DingoSchema toDingoSchema(int index) {
        return null;
    }

    @Override
    public String format(@Nullable Object value) {
        if (value != null) {
            Object[] tuple = (Object[])value;
            this.checkFieldCount(tuple);
            StringBuilder b = new StringBuilder();
            b.append("{ ");
            for (int i = 0; i < tuple.length; ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.fields[i].format(tuple[i]));
            }
            b.append(" }");
            return b.toString();
        }
        return NullType.NULL.format(null);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[ ");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.fields[i]);
        }
        b.append(" ]");
        return b.toString();
    }

    @Nonnull
    private Object[] checkFieldCount(@Nonnull Object[] tuple) {
        if (tuple.length == this.fieldCount()) {
            return tuple;
        }
        throw new IllegalArgumentException("Required " + this.fieldCount() + " elements, but " + tuple.length + " provided.");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TupleType)) {
            return false;
        }
        TupleType other = (TupleType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getFields(), other.getFields());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TupleType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        return result;
    }

    public DingoType[] getFields() {
        return this.fields;
    }
}

