/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.converter;

import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.converter.DataConverter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;

public class AvroConverter
implements DataConverter {
    public static final AvroConverter INSTANCE = new AvroConverter();

    private AvroConverter() {
    }

    @Override
    public Long convert(@Nonnull Date value) {
        return value.getTime();
    }

    @Override
    public Long convert(@Nonnull Time value) {
        return value.getTime();
    }

    @Override
    public Long convert(@Nonnull Timestamp value) {
        return value.getTime();
    }

    @Override
    public ByteBuffer convert(@Nonnull byte[] value) {
        return ByteBuffer.wrap(value);
    }

    @Override
    public Object convert(@Nonnull BigDecimal value) {
        return ByteBuffer.wrap(value.toString().getBytes());
    }

    @Override
    public List<Object> convert(@Nonnull Object[] value, DingoType elementType) {
        return Arrays.stream(value).map(v -> elementType.convertTo(v, this)).collect(Collectors.toList());
    }

    @Override
    public String convertStringFrom(@Nonnull Object value) {
        if (value instanceof Utf8) {
            return value.toString();
        }
        return (String)value;
    }

    @Override
    public BigDecimal convertDecimalFrom(@Nonnull Object value) {
        return new BigDecimal(new String(((ByteBuffer)value).array()));
    }

    @Override
    public Date convertDateFrom(@Nonnull Object value) {
        return new Date((Long)value);
    }

    @Override
    public Time convertTimeFrom(@Nonnull Object value) {
        return new Time((Long)value);
    }

    @Override
    public Timestamp convertTimestampFrom(@Nonnull Object value) {
        return new Timestamp((Long)value);
    }

    @Override
    public byte[] convertBinaryFrom(@Nonnull Object value) {
        return ((ByteBuffer)value).array();
    }

    @Override
    public Object[] convertArrayFrom(@Nonnull Object value, DingoType elementType) {
        GenericData.Array array = (GenericData.Array)value;
        return array.stream().map(o -> elementType.convertFrom(o, this)).toArray(Object[]::new);
    }
}

