/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.converter;

import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvConverter
implements DataConverter {
    private static final Logger log = LoggerFactory.getLogger(CsvConverter.class);
    public static final CsvConverter INSTANCE = new CsvConverter();

    private CsvConverter() {
    }

    @Override
    public boolean isNull(@Nonnull Object value) {
        return value.equals("null") || value.equals("NULL");
    }

    @Override
    public Integer convertIntegerFrom(@Nonnull Object value) {
        if (value == null || value.toString().trim().isEmpty()) {
            return null;
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    public Long convertLongFrom(@Nonnull Object value) {
        if (value == null || value.toString().trim().isEmpty()) {
            return null;
        }
        return Long.parseLong(value.toString());
    }

    @Override
    public Double convertDoubleFrom(@Nonnull Object value) {
        if (value == null || value.toString().trim().isEmpty()) {
            return null;
        }
        return Double.parseDouble(value.toString());
    }

    @Override
    public Boolean convertBooleanFrom(@Nonnull Object value) {
        String str = value.toString();
        if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (str.trim().length() == 0) {
            log.warn("Empty string will return Null.");
            return null;
        }
        try {
            int aInt = Integer.parseInt(str);
            return aInt != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (NumberFormatException ignored) {
            log.error("Failed to parse boolean value: {}", (Object)str, (Object)ignored);
            throw new IllegalArgumentException("Failed to parse boolean value: " + str);
        }
    }

    @Override
    public BigDecimal convertDecimalFrom(@Nonnull Object value) {
        if (value == null || value.toString().trim().isEmpty()) {
            return null;
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public Date convertDateFrom(@Nonnull Object value) {
        String strValue = value instanceof String ? (String)value : value.toString();
        return DateTimeUtils.parseDate(strValue);
    }

    @Override
    public Time convertTimeFrom(@Nonnull Object value) {
        String strValue = value instanceof String ? (String)value : value.toString();
        return DateTimeUtils.parseTime(strValue);
    }

    @Override
    public Timestamp convertTimestampFrom(@Nonnull Object value) {
        String strValue = value instanceof String ? (String)value : value.toString();
        return DateTimeUtils.parseTimestamp(strValue);
    }

    @Override
    public byte[] convertBinaryFrom(@Nonnull Object value) {
        String strValue = value instanceof String ? (String)value : value.toString();
        return strValue.getBytes(StandardCharsets.UTF_8);
    }
}

