/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.converter;

import io.dingodb.common.type.DingoType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public interface DataConverter {
    public static final DataConverter DEFAULT = new DataConverter(){};

    default public boolean isNull(@Nonnull Object value) {
        return false;
    }

    default public Object convert(@Nonnull Date value) {
        return value;
    }

    default public Object convert(@Nonnull Time value) {
        return value;
    }

    default public Object convert(@Nonnull Timestamp value) {
        return value;
    }

    default public Object convert(@Nonnull byte[] value) {
        return value;
    }

    default public Object convert(@Nonnull BigDecimal value) {
        return value;
    }

    default public Object convert(@Nonnull Object[] value, DingoType elementType) {
        return Arrays.stream(value).map(v -> elementType.convertTo(v, this)).toArray(Object[]::new);
    }

    default public Object convert(@Nonnull List<?> value, DingoType elementType) {
        return value.stream().map(v -> elementType.convertTo(v, this)).collect(Collectors.toList());
    }

    default public Object convert(@Nonnull Map<?, ?> value, DingoType keyType, DingoType valueType) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            result.put(keyType.convertTo(entry.getKey(), this), valueType.convertTo(entry.getValue(), this));
        }
        return result;
    }

    default public Integer convertIntegerFrom(@Nonnull Object value) {
        return (Integer)value;
    }

    default public Long convertLongFrom(@Nonnull Object value) {
        return (Long)value;
    }

    default public Double convertDoubleFrom(@Nonnull Object value) {
        return (Double)value;
    }

    default public Boolean convertBooleanFrom(@Nonnull Object value) {
        return (Boolean)value;
    }

    default public String convertStringFrom(@Nonnull Object value) {
        return (String)value;
    }

    default public BigDecimal convertDecimalFrom(@Nonnull Object value) {
        return (BigDecimal)value;
    }

    default public Date convertDateFrom(@Nonnull Object value) {
        return (Date)value;
    }

    default public Time convertTimeFrom(@Nonnull Object value) {
        return (Time)value;
    }

    default public Timestamp convertTimestampFrom(@Nonnull Object value) {
        return (Timestamp)value;
    }

    default public byte[] convertBinaryFrom(@Nonnull Object value) {
        return (byte[])value;
    }

    default public Object[] convertTupleFrom(@Nonnull Object value, @Nonnull DingoType type2) {
        Object[] tuple = (Object[])value;
        return IntStream.range(0, tuple.length).mapToObj(i -> Objects.requireNonNull(type2.getChild(i)).convertFrom(tuple[i], this)).toArray(Object[]::new);
    }

    default public Object[] convertArrayFrom(@Nonnull Object value, DingoType elementType) {
        return Arrays.stream((Object[])value).map(e -> elementType.convertFrom(e, this)).toArray(Object[]::new);
    }

    default public List<?> convertListFrom(@Nonnull Object value, DingoType elementType) {
        return ((List)value).stream().map(e -> elementType.convertFrom(e, this)).collect(Collectors.toList());
    }

    default public Map<Object, Object> convertMapFrom(@Nonnull Object value, DingoType keyType, DingoType valueType) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry entry : ((Map)value).entrySet()) {
            result.put(keyType.convertFrom(entry.getKey(), this), valueType.convertFrom(entry.getValue(), this));
        }
        return result;
    }

    default public Object collectTuple(@Nonnull Stream<Object> stream) {
        return stream.toArray(Object[]::new);
    }
}

