/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.converter;

import io.dingodb.common.type.converter.DataConverter;
import java.math.BigDecimal;
import javax.annotation.Nonnull;

public class ExprConverter
implements DataConverter {
    public static final ExprConverter INSTANCE = new ExprConverter();

    private ExprConverter() {
    }

    @Override
    public Integer convertIntegerFrom(@Nonnull Object value) {
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return (Integer)value;
    }

    @Override
    public Double convertDoubleFrom(@Nonnull Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        return ((BigDecimal)value).doubleValue();
    }

    @Override
    public BigDecimal convertDecimalFrom(@Nonnull Object value) {
        if (value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf((Long)value);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        return (BigDecimal)value;
    }
}

