/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.converter;

import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.expr.runtime.utils.NumberUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.util.NlsString;

public class RexLiteralConverter
implements DataConverter {
    public static final RexLiteralConverter INSTANCE = new RexLiteralConverter();
    private static final RuntimeException NEVER_CONVERT_BACK = new IllegalStateException("Convert back to RexLiteral should be avoided.");

    private RexLiteralConverter() {
    }

    @Override
    public Object convert(@Nonnull Date value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull Time value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull Timestamp value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull byte[] value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull Object[] value, DingoType elementType) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Integer convertIntegerFrom(@Nonnull Object value) {
        long v = ((BigDecimal)value).setScale(0, RoundingMode.HALF_UP).longValue();
        return NumberUtils.checkIntRange(v);
    }

    @Override
    public Long convertLongFrom(@Nonnull Object value) {
        return ((BigDecimal)value).setScale(0, RoundingMode.HALF_UP).longValue();
    }

    @Override
    public Double convertDoubleFrom(@Nonnull Object value) {
        return ((BigDecimal)value).doubleValue();
    }

    @Override
    public String convertStringFrom(@Nonnull Object value) {
        return ((NlsString)value).getValue();
    }

    @Override
    public Date convertDateFrom(@Nonnull Object value) {
        return new Date(((Calendar)value).getTimeInMillis());
    }

    @Override
    public Time convertTimeFrom(@Nonnull Object value) {
        return new Time(((Calendar)value).getTimeInMillis());
    }

    @Override
    public Timestamp convertTimestampFrom(@Nonnull Object value) {
        Calendar calendar = (Calendar)value;
        long v = calendar.getTimeInMillis();
        return new Timestamp(v - (long)calendar.getTimeZone().getOffset(v));
    }

    @Override
    public byte[] convertBinaryFrom(@Nonnull Object value) {
        return ((ByteString)value).getBytes();
    }
}

