/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.converter;

import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.converter.ConverterWithCalendar;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.annotation.Nonnull;

public class TypedValueConverter
extends ConverterWithCalendar {
    private static final RuntimeException NEVER_CONVERT_BACK = new IllegalStateException("Convert back to TypedValue should be avoided.");

    public TypedValueConverter(Calendar localCalendar) {
        super(localCalendar);
    }

    @Override
    public Object convert(@Nonnull Date value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull Time value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull Timestamp value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull byte[] value) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Object convert(@Nonnull Object[] value, DingoType elementType) {
        throw NEVER_CONVERT_BACK;
    }

    @Override
    public Integer convertIntegerFrom(@Nonnull Object value) {
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return super.convertIntegerFrom(value);
    }

    @Override
    public Date convertDateFrom(@Nonnull Object value) {
        return new Date((long)((Integer)value).intValue() * 86400000L);
    }

    @Override
    public Time convertTimeFrom(@Nonnull Object value) {
        return new Time(((Integer)value).intValue());
    }

    @Override
    public Timestamp convertTimestampFrom(@Nonnull Object value) {
        return this.unShiftedTimestamp((Long)value);
    }
}

