/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.scalar;

import io.dingodb.common.type.NullType;
import io.dingodb.common.type.NullableType;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.expr.runtime.TypeCode;
import io.dingodb.serial.schema.DingoSchema;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

public abstract class AbstractScalarType
extends NullableType {
    protected AbstractScalarType(int typeCode, boolean nullable) {
        super(typeCode, nullable);
    }

    @Override
    protected Schema toAvroSchemaNotNull() {
        Schema.Type t = this.getAvroSchemaType();
        return Schema.create(t);
    }

    @Override
    public List<DingoSchema> toDingoSchemas() {
        return null;
    }

    @Override
    public String format(@Nullable Object value) {
        return value != null ? value + ":" + this : NullType.NULL.format(null);
    }

    @Override
    protected Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        return value;
    }

    @Override
    protected Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        return value;
    }

    @Override
    public int fieldCount() {
        return -1;
    }

    public String toString() {
        String name = TypeCode.nameOf(this.typeCode);
        return this.nullable ? name + "|" + NullType.NULL : name;
    }

    protected abstract Schema.Type getAvroSchemaType();
}

