/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.scalar;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.common.type.scalar.AbstractScalarType;
import io.dingodb.serial.schema.DingoSchema;
import io.dingodb.serial.schema.DoubleSchema;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;

@JsonTypeName(value="double")
public class DoubleType
extends AbstractScalarType {
    @JsonCreator
    public DoubleType(@JsonProperty(value="nullable") boolean nullable) {
        super(761287205, nullable);
    }

    @Override
    public DoubleType copy() {
        return new DoubleType(this.nullable);
    }

    @Override
    public DingoSchema toDingoSchema(int index) {
        return new DoubleSchema(index);
    }

    @Override
    protected Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue()).doubleValue();
        }
        return super.convertValueTo(value, converter);
    }

    @Override
    protected Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convertDoubleFrom(value);
    }

    @Override
    protected Schema.Type getAvroSchemaType() {
        return Schema.Type.DOUBLE;
    }
}

