/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.scalar;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.type.converter.AvaticaResultSetConverter;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.common.type.scalar.AbstractScalarType;
import io.dingodb.serial.schema.BytesSchema;
import io.dingodb.serial.schema.DingoSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;

@JsonTypeName(value="object")
public class ObjectType
extends AbstractScalarType {
    @JsonCreator
    public ObjectType(@JsonProperty(value="nullable") boolean nullable) {
        super(1063877011, nullable);
    }

    @Override
    public ObjectType copy() {
        return new ObjectType(this.nullable);
    }

    @Override
    public DingoSchema toDingoSchema(int index) {
        return new BytesSchema(index);
    }

    @Override
    protected Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        if (converter instanceof AvaticaResultSetConverter) {
            return value;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            byte[] result = bos.toByteArray();
            oos.close();
            bos.close();
            return converter.convert(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(converter.convertBinaryFrom(value));
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object result = ois.readObject();
            ois.close();
            bis.close();
            return result;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Schema.Type getAvroSchemaType() {
        return Schema.Type.BYTES;
    }
}

