/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.type.scalar;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.type.NullType;
import io.dingodb.common.type.converter.DataConverter;
import io.dingodb.common.type.scalar.AbstractScalarType;
import io.dingodb.expr.runtime.utils.DateTimeUtils;
import io.dingodb.serial.schema.DingoSchema;
import io.dingodb.serial.schema.LongSchema;
import java.sql.Timestamp;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

@JsonTypeName(value="timestamp")
public class TimestampType
extends AbstractScalarType {
    @JsonCreator
    public TimestampType(@JsonProperty(value="nullable") boolean nullable) {
        super(1252880906, nullable);
    }

    @Override
    public TimestampType copy() {
        return new TimestampType(this.nullable);
    }

    @Override
    public DingoSchema toDingoSchema(int index) {
        return new LongSchema(index);
    }

    @Override
    public String format(@Nullable Object value) {
        return value != null ? DateTimeUtils.timestampFormat((Timestamp)value) + ":" + this : NullType.NULL.format(null);
    }

    @Override
    protected Object convertValueTo(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convert((Timestamp)value);
    }

    @Override
    protected Object convertValueFrom(@Nonnull Object value, @Nonnull DataConverter converter) {
        return converter.convertTimestampFrom(value);
    }

    @Override
    protected Schema.Type getAvroSchemaType() {
        return Schema.Type.LONG;
    }
}

