/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

public class ByteArrayUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final byte[] MAX_BYTES = new byte[]{-1};

    private ByteArrayUtils() {
    }

    public static int compare(byte[] bytes1, byte[] bytes2) {
        if (Arrays.equals(bytes1, bytes2)) {
            return 0;
        }
        int n = Math.min(bytes1.length, bytes2.length);
        for (int i = 0; i < n; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return (bytes1[i] & 0xFF) - (bytes2[i] & 0xFF);
        }
        return bytes1.length - bytes2.length;
    }

    public static int compareContainsEnd(byte[] bytes1, byte[] bytes2) {
        if (Arrays.equals(bytes1, bytes2)) {
            return 0;
        }
        int n = Math.min(bytes1.length, bytes2.length);
        for (int i = 0; i < n; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return (bytes1[i] & 0xFF) - (bytes2[i] & 0xFF);
        }
        return 0;
    }

    public static boolean equal(byte[] bytes1, byte[] bytes2) {
        return bytes2 != null && ByteArrayUtils.compare(bytes1, bytes2) == 0;
    }

    public static boolean lessThan(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compare(bytes1, bytes2) < 0;
    }

    public static boolean greatThan(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compare(bytes1, bytes2) > 0;
    }

    public static boolean lessThanOrEqual(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compareContainsEnd(bytes1, bytes2) <= 0;
    }

    public static boolean greatThanOrEqual(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compareContainsEnd(bytes1, bytes2) >= 0;
    }

    public static String enCodeBytes2Base64(byte[] input) {
        byte[] encoded = Base64.getEncoder().encode(input);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static byte[] deCodeBase64String2Bytes(String input) {
        byte[] decoded = Base64.getDecoder().decode(input);
        return decoded;
    }

    public static void main(String[] args) {
        String input = "hello world";
        String encoded = ByteArrayUtils.enCodeBytes2Base64(input.getBytes(StandardCharsets.UTF_8));
        byte[] decodeBytes = ByteArrayUtils.deCodeBase64String2Bytes(encoded);
        String decodeInStr = new String(decodeBytes, StandardCharsets.UTF_8);
        System.out.println("=====> DeEncode: " + decodeInStr);
    }

    public static class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        @JsonProperty
        private byte[] bytes;

        @Override
        public int compareTo(ComparableByteArray other) {
            return ByteArrayUtils.compare(this.bytes, other.bytes);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        @JsonProperty
        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return "ByteArrayUtils.ComparableByteArray(bytes=" + Arrays.toString(this.getBytes()) + ")";
        }

        public ComparableByteArray() {
        }

        public ComparableByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparableByteArray)) {
                return false;
            }
            ComparableByteArray other = (ComparableByteArray)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.getBytes(), other.getBytes());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComparableByteArray;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getBytes());
            return result;
        }
    }
}

