/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Iterators;
import io.dingodb.common.type.DingoType;
import io.dingodb.common.type.DingoTypeFactory;
import io.dingodb.common.type.TupleType;
import io.dingodb.expr.json.runtime.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CsvUtils {
    private static final Parser PARSER = Parser.CSV;

    private CsvUtils() {
    }

    @Nonnull
    public static Iterator<String[]> readCsv(InputStream is) throws IOException {
        return PARSER.readValues(is, String[].class);
    }

    @Nonnull
    public static Iterator<Object[]> readCsv(@Nonnull DingoType schema, InputStream is) throws IOException {
        return Iterators.transform(CsvUtils.readCsv(is), i -> (Object[])schema.parse(i));
    }

    @Nonnull
    public static List<Object[]> readCsv(@Nonnull DingoType schema, String lines) throws JsonProcessingException {
        return Arrays.stream((Object[])PARSER.parse(lines, String[][].class)).map(i -> (Object[])schema.parse(i)).collect(Collectors.toList());
    }

    @Nonnull
    public static Iterator<Object[]> readCsvWithSchema(InputStream is) throws IOException {
        Iterator<String[]> it = PARSER.readValues(is, String[].class);
        if (it.hasNext()) {
            String[] types = it.next();
            TupleType schema = DingoTypeFactory.tuple(types);
            return Iterators.transform(it, i -> (Object[])schema.parse(i));
        }
        return Iterators.transform(it, s2 -> s2);
    }
}

