/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optional<T> {
    private static final Logger log = LoggerFactory.getLogger(Optional.class);
    public static final Optional<?> EMPTY = Optional.of(java.util.Optional.empty());
    private final java.util.Optional<T> optional;

    private Optional(java.util.Optional<T> optional) {
        this.optional = optional;
    }

    public static <T> Optional<T> of(java.util.Optional optional) {
        return new Optional<T>(optional);
    }

    public static <T> Optional<T> of(T value) {
        return Optional.of(java.util.Optional.of(value));
    }

    public static <T> Optional<T> ofNullable(T value) {
        return Optional.of(java.util.Optional.ofNullable(value));
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public T get() {
        return this.optional.get();
    }

    public boolean isAbsent() {
        return !this.isPresent();
    }

    public boolean isPresent() {
        return this.optional.isPresent();
    }

    public Optional<T> ifPresent(Consumer<? super T> consumer) {
        this.optional.ifPresent(consumer);
        return this;
    }

    public Optional<T> ifPresent(Runnable runnable) {
        if (this.optional.isPresent()) {
            runnable.run();
        }
        return this;
    }

    public static <T> void ifPresent(T value, Runnable runnable) {
        if (value == null) {
            return;
        }
        runnable.run();
    }

    public static <T> void ifPresent(T value, Consumer<? super T> consumer) {
        if (value == null) {
            return;
        }
        consumer.accept(value);
    }

    public Optional<T> ifAbsent(Runnable runnable) {
        if (!this.optional.isPresent()) {
            runnable.run();
        }
        return this;
    }

    public Optional<T> ifAbsentSet(T other) {
        if (!this.optional.isPresent()) {
            return Optional.ofNullable(other);
        }
        return this;
    }

    public Optional<T> ifAbsentSet(Supplier<? extends T> other) {
        if (!this.optional.isPresent()) {
            return Optional.ofNullable(other.get());
        }
        return this;
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        return Optional.of(this.optional.filter(predicate));
    }

    public Optional<T> filter(Supplier<Boolean> predicate) {
        if (predicate.get().booleanValue()) {
            return this;
        }
        return Optional.empty();
    }

    public Optional<T> filter(boolean whether) {
        if (whether) {
            return this;
        }
        return Optional.empty();
    }

    public <U> Optional<U> map(Function<? super T, U> mapper) {
        return Optional.of(this.optional.map(mapper));
    }

    public <U> Optional<U> flatMap(Function<? super T, java.util.Optional<T>> mapper) {
        return Optional.of(this.optional.flatMap(mapper));
    }

    @Deprecated
    public T orElse(T other) throws Exception {
        throw new UnsupportedOperationException("Use orElseGet method.");
    }

    public <U> U mapOrNull(Function<? super T, U> mapper) {
        return this.optional.map(mapper).orElse(null);
    }

    public static <T, U> U mapOrNull(T value, Function<? super T, U> mapper) {
        return value == null ? null : (U)mapper.apply((T)value);
    }

    public <U> U mapOrGet(Function<? super T, U> mapper, Supplier<U> other) {
        return this.optional.map(mapper).orElseGet(other);
    }

    public static <T, U> U mapOrGet(T value, Function<? super T, ? extends U> mapper, Supplier<U> other) {
        return value == null ? other.get() : mapper.apply(value);
    }

    public T orNull() {
        return this.optional.orElse(null);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.optional.orElseGet(other);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.optional.orElseThrow(exceptionSupplier);
    }
}

