/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.util;

import io.dingodb.common.util.StackTraces;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parameters {
    private static final Logger log = LoggerFactory.getLogger(Parameters.class);

    private Parameters() {
    }

    public static <T> T nonNull(T input, String message) {
        return (T)Parameters.check(input, Objects::nonNull, () -> new NullPointerException(message));
    }

    public static <T> T nonNull(T input, Supplier<RuntimeException> throwableSupplier) {
        return (T)Parameters.check(input, Objects::nonNull, throwableSupplier);
    }

    public static <T> T mustNull(T input, Supplier<RuntimeException> throwableSupplier) {
        return (T)Parameters.check(input, Objects::isNull, throwableSupplier);
    }

    public static <T> T mustNull(T input, Function<T, RuntimeException> throwableSupplier) {
        return (T)Parameters.check(input, Objects::isNull, () -> (RuntimeException)throwableSupplier.apply(input));
    }

    public static <T> T check(T input, Predicate<T> checkFunction, Supplier<RuntimeException> throwableSupplier) {
        Exception testEx = null;
        try {
            if (checkFunction.test(input)) {
                return input;
            }
        }
        catch (Exception e) {
            log.error("Run check function error, input is: --[{}]--, caller is [{}].", input, StackTraces.methodName(2), e);
            testEx = e;
        }
        RuntimeException exception = throwableSupplier.get();
        if (exception == null) {
            if (testEx == null) {
                log.warn("Run check function error, input is: --[{}]--, caller is [{}].", (Object)input, (Object)StackTraces.methodName(2));
            } else {
                log.warn("Run check function error, but it is ignore, input is: --[{}]--, caller is [{}].", (Object)input, (Object)StackTraces.methodName(2));
            }
            return input;
        }
        throw exception;
    }

    public static <T> T cleanNull(T input, T defaultValue) {
        return (T)Parameters.clean(input, Objects::nonNull, defaultValue);
    }

    public static <T> T cleanNull(T input, Supplier<T> valueSupplier) {
        return (T)Parameters.clean(input, Objects::nonNull, valueSupplier);
    }

    public static <T> T clean(T input, Predicate<T> checkFunction, Supplier<T> valueSupplier) {
        try {
            if (checkFunction.test(input)) {
                return input;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valueSupplier.get();
    }

    public static <T> T clean(T input, Predicate<T> checkFunction, T defaultValue) {
        try {
            if (checkFunction.test(input)) {
                return input;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

