/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.util;

import io.dingodb.serial.schema.DingoSchema;
import java.util.ArrayList;
import java.util.List;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public final class UdfUtils {
    private UdfUtils() {
    }

    public static LuaTable getLuaTable(List<DingoSchema> schemaList, Object[] record) {
        LuaTable table = new LuaTable();
        for (DingoSchema schema : schemaList) {
            switch (schema.getType()) {
                case BOOLEAN: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf((Boolean)record[schema.getIndex()]));
                    break;
                }
                case BOOLEANLIST: {
                    LuaTable booleanList = new LuaTable();
                    List booleans = (List)record[schema.getIndex()];
                    for (int i = 0; i < booleans.size(); ++i) {
                        booleanList.set(i, (LuaValue)LuaValue.valueOf((Boolean)booleans.get(i)));
                    }
                    table.set(schema.getIndex(), (LuaValue)booleanList);
                    break;
                }
                case SHORT: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf(((Short)record[schema.getIndex()]).shortValue()));
                    break;
                }
                case SHORTLIST: {
                    LuaTable shortList = new LuaTable();
                    List shorts = (List)record[schema.getIndex()];
                    for (int i = 0; i < shorts.size(); ++i) {
                        shortList.set(i, (LuaValue)LuaValue.valueOf(((Short)shorts.get(i)).shortValue()));
                    }
                    table.set(schema.getIndex(), (LuaValue)shortList);
                    break;
                }
                case INTEGER: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf((Integer)record[schema.getIndex()]));
                    break;
                }
                case INTEGERLIST: {
                    LuaTable intList = new LuaTable();
                    List ints = (List)record[schema.getIndex()];
                    for (int i = 0; i < ints.size(); ++i) {
                        intList.set(i, (LuaValue)LuaValue.valueOf((Integer)ints.get(i)));
                    }
                    table.set(schema.getIndex(), (LuaValue)intList);
                    break;
                }
                case FLOAT: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf(((Float)record[schema.getIndex()]).floatValue()));
                    break;
                }
                case FLOATLIST: {
                    LuaTable floatList = new LuaTable();
                    List floats = (List)record[schema.getIndex()];
                    for (int i = 0; i < floats.size(); ++i) {
                        floatList.set(i, (LuaValue)LuaValue.valueOf(((Float)floats.get(i)).floatValue()));
                    }
                    table.set(schema.getIndex(), (LuaValue)floatList);
                    break;
                }
                case LONG: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf(((Long)record[schema.getIndex()]).longValue()));
                    break;
                }
                case LONGLIST: {
                    LuaTable longList = new LuaTable();
                    List longs = (List)record[schema.getIndex()];
                    for (int i = 0; i < longs.size(); ++i) {
                        longList.set(i, (LuaValue)LuaValue.valueOf(((Long)longs.get(i)).longValue()));
                    }
                    table.set(schema.getIndex(), (LuaValue)longList);
                    break;
                }
                case DOUBLE: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf((Double)record[schema.getIndex()]));
                    break;
                }
                case DOUBLELIST: {
                    LuaTable doubleList = new LuaTable();
                    List doubles = (List)record[schema.getIndex()];
                    for (int i = 0; i < doubles.size(); ++i) {
                        doubleList.set(i, (LuaValue)LuaValue.valueOf((Double)doubles.get(i)));
                    }
                    table.set(schema.getIndex(), (LuaValue)doubleList);
                    break;
                }
                case STRING: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf((String)record[schema.getIndex()]));
                    break;
                }
                case STRINGLIST: {
                    LuaTable stringList = new LuaTable();
                    List strings = (List)record[schema.getIndex()];
                    for (int i = 0; i < strings.size(); ++i) {
                        stringList.set(i, (LuaValue)LuaValue.valueOf((String)strings.get(i)));
                    }
                    table.set(schema.getIndex(), (LuaValue)stringList);
                    break;
                }
                case BYTES: {
                    table.set(schema.getIndex(), (LuaValue)LuaValue.valueOf((byte[])record[schema.getIndex()]));
                    break;
                }
                case BYTESLIST: {
                    LuaTable bytesList = new LuaTable();
                    List bytess = (List)record[schema.getIndex()];
                    for (int i = 0; i < bytess.size(); ++i) {
                        bytesList.set(i, (LuaValue)LuaValue.valueOf((byte[])bytess.get(i)));
                    }
                    table.set(schema.getIndex(), (LuaValue)bytesList);
                    break;
                }
            }
        }
        return table;
    }

    public static Object[] getObject(List<DingoSchema> schemaList, LuaValue result) {
        Object[] record = new Object[schemaList.size()];
        for (DingoSchema schema : schemaList) {
            switch (schema.getType()) {
                case BOOLEAN: {
                    record[schema.getIndex()] = result.get(schema.getIndex()).toboolean();
                    break;
                }
                case BOOLEANLIST: {
                    LuaTable booleanList = (LuaTable)result.get(schema.getIndex());
                    ArrayList<Boolean> booleans = new ArrayList<Boolean>();
                    for (int i = 0; i <= booleanList.length(); ++i) {
                        booleans.add(i, booleanList.get(i).toboolean());
                    }
                    record[schema.getIndex()] = booleans;
                    break;
                }
                case SHORT: {
                    record[schema.getIndex()] = result.get(schema.getIndex()).toshort();
                    break;
                }
                case SHORTLIST: {
                    LuaTable shortList = (LuaTable)result.get(schema.getIndex());
                    ArrayList<Short> shorts = new ArrayList<Short>();
                    for (int i = 0; i <= shortList.length(); ++i) {
                        shorts.add(i, shortList.get(i).toshort());
                    }
                    record[schema.getIndex()] = shorts;
                    break;
                }
                case INTEGER: {
                    record[schema.getIndex()] = result.get(schema.getIndex()).toint();
                    break;
                }
                case INTEGERLIST: {
                    LuaTable intList = (LuaTable)result.get(schema.getIndex());
                    ArrayList<Integer> ints = new ArrayList<Integer>();
                    for (int i = 0; i <= intList.length(); ++i) {
                        ints.add(i, intList.get(i).toint());
                    }
                    record[schema.getIndex()] = ints;
                    break;
                }
                case FLOAT: {
                    record[schema.getIndex()] = Float.valueOf(result.get(schema.getIndex()).tofloat());
                    break;
                }
                case FLOATLIST: {
                    LuaTable floatList = (LuaTable)result.get(schema.getIndex());
                    ArrayList<Float> floats = new ArrayList<Float>();
                    for (int i = 0; i <= floatList.length(); ++i) {
                        floats.add(i, Float.valueOf(floatList.get(i).tofloat()));
                    }
                    record[schema.getIndex()] = floats;
                    break;
                }
                case LONG: {
                    record[schema.getIndex()] = result.get(schema.getIndex()).tolong();
                    break;
                }
                case LONGLIST: {
                    LuaTable longList = (LuaTable)result.get(schema.getIndex());
                    ArrayList<Long> longs = new ArrayList<Long>();
                    for (int i = 0; i <= longList.length(); ++i) {
                        longs.add(i, longList.get(i).tolong());
                    }
                    record[schema.getIndex()] = longs;
                    break;
                }
                case DOUBLE: {
                    record[schema.getIndex()] = result.get(schema.getIndex()).todouble();
                    break;
                }
                case DOUBLELIST: {
                    LuaTable doubleList = (LuaTable)result.get(schema.getIndex());
                    ArrayList<Double> doubles = new ArrayList<Double>();
                    for (int i = 0; i <= doubleList.length(); ++i) {
                        doubles.add(i, doubleList.get(i).todouble());
                    }
                    record[schema.getIndex()] = doubles;
                    break;
                }
                case STRING: {
                    record[schema.getIndex()] = result.get(schema.getIndex()).toString();
                    break;
                }
                case STRINGLIST: {
                    LuaTable stringList = (LuaTable)result.get(schema.getIndex());
                    ArrayList<String> strings = new ArrayList<String>();
                    for (int i = 0; i <= stringList.length(); ++i) {
                        strings.add(i, stringList.get(i).toString());
                    }
                    record[schema.getIndex()] = strings;
                    break;
                }
                case BYTES: {
                    break;
                }
                case BYTESLIST: {
                    break;
                }
            }
        }
        return record;
    }
}

