/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.util;

import io.dingodb.common.util.NoBreakFunctions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class Utils {
    private Utils() {
    }

    public static <T> T sole(@Nonnull Collection<T> collection) {
        Iterator<T> iterator;
        if (collection.size() == 1 && (iterator = collection.iterator()).hasNext()) {
            T obj = iterator.next();
            return obj;
        }
        throw new IllegalArgumentException("The collection contains zero or more than one elements.");
    }

    public static int max(@Nonnull int[] arr) {
        assert (arr.length > 0);
        int max2 = arr[0];
        for (int i : arr) {
            if (i <= max2) continue;
            max2 = i;
        }
        return max2;
    }

    @Nonnull
    public static <T> T[] combine(@Nonnull T[] left, @Nonnull T[] right) {
        T[] res = Arrays.copyOf(left, left.length + right.length);
        System.arraycopy(right, 0, res, left.length, right.length);
        return res;
    }

    public static void loop(Supplier<Boolean> predicate) {
        while (predicate.get().booleanValue()) {
        }
    }

    public static void noBreakLoop(NoBreakFunctions.Supplier<Boolean> predicate) {
        try {
            while (predicate.get().booleanValue()) {
            }
        }
        catch (Throwable e) {}
    }

    public static void noBreakLoop(NoBreakFunctions.Supplier<Boolean> predicate, Consumer<Throwable> exceptionHandler) {
        try {
            while (predicate.get().booleanValue()) {
            }
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
        }
    }
}

