/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.json.runtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import javax.annotation.Nonnull;

public enum DataFormat {
    APPLICATION_JSON("application/json"),
    APPLICATION_YAML("application/yaml"),
    TEXT_CSV("text/csv");

    @JsonValue
    private final String value;

    private DataFormat(String value) {
        this.value = value;
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    @Nonnull
    public static DataFormat fromString(String str) {
        for (DataFormat dataFormat : DataFormat.values()) {
            if (!str.equals(dataFormat.getValue())) continue;
            return dataFormat;
        }
        throw new IllegalArgumentException("Invalid string value \"" + str + "\" for enum type \"" + DataFormat.class.getSimpleName() + "\".");
    }

    @Nonnull
    public static DataFormat fromExtension(@Nonnull String fileName) {
        if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
            return APPLICATION_YAML;
        }
        if (fileName.endsWith(".json")) {
            return APPLICATION_JSON;
        }
        if (fileName.endsWith(".csv")) {
            return TEXT_CSV;
        }
        throw new IllegalArgumentException("Invalid extension of file name \"" + fileName + "\" for enum type \"" + DataFormat.class.getSimpleName() + "\".");
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }
}

