/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.json.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.dingodb.expr.json.runtime.DataFormat;
import io.dingodb.expr.json.runtime.Parser;
import io.dingodb.expr.json.runtime.RtSchema;
import io.dingodb.expr.json.runtime.RtSchemaArray;
import io.dingodb.expr.json.runtime.RtSchemaDict;
import io.dingodb.expr.json.runtime.RtSchemaRoot;
import io.dingodb.expr.json.runtime.RtSchemaTuple;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DataParser
extends Parser {
    private static final long serialVersionUID = -6849693677072717377L;
    private final RtSchemaRoot schemaRoot;

    private DataParser(@Nonnull DataFormat format2, RtSchemaRoot schemaRoot) {
        super(format2);
        this.schemaRoot = schemaRoot;
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.disable(SerializationFeature.INDENT_OUTPUT);
    }

    @Nonnull
    public static DataParser json(RtSchemaRoot schemaRoot) {
        return new DataParser(DataFormat.APPLICATION_JSON, schemaRoot);
    }

    @Nonnull
    public static DataParser yaml(RtSchemaRoot schemaRoot) {
        return new DataParser(DataFormat.APPLICATION_YAML, schemaRoot);
    }

    @Nonnull
    public static DataParser get(@Nonnull DataFormat format2, RtSchemaRoot schemaRoot) {
        return new DataParser(format2, schemaRoot);
    }

    @Nullable
    private static Object jsonNodeValue(@Nonnull JsonNode jsonNode) {
        JsonNodeType type2 = jsonNode.getNodeType();
        switch (type2) {
            case NUMBER: {
                if (jsonNode.isInt() || jsonNode.isLong()) {
                    return jsonNode.asLong();
                }
                return jsonNode.asDouble();
            }
            case STRING: {
                return jsonNode.asText();
            }
            case BOOLEAN: {
                return jsonNode.asBoolean();
            }
            case ARRAY: {
                LinkedList<Object> list = new LinkedList<Object>();
                for (int i = 0; i < jsonNode.size(); ++i) {
                    list.add(DataParser.jsonNodeValue(jsonNode.get(i)));
                }
                return list;
            }
            case OBJECT: {
                HashMap<String, Object> map = new HashMap<String, Object>(jsonNode.size());
                Iterator<Map.Entry<String, JsonNode>> it = jsonNode.fields();
                while (it.hasNext()) {
                    Map.Entry<String, JsonNode> entry = it.next();
                    map.put(entry.getKey(), DataParser.jsonNodeValue(entry.getValue()));
                }
                return map;
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported json node type \"" + (Object)((Object)type2) + "\".");
    }

    private static void parseAccordingSchema(Object[] tuple, @Nonnull JsonNode jsonNode, @Nonnull RtSchema rtSchema) {
        if (jsonNode.isNull()) {
            tuple[rtSchema.getIndex()] = null;
            return;
        }
        switch (rtSchema.getTypeCode()) {
            case 110725064: {
                RtSchemaTuple schemaTuple = (RtSchemaTuple)rtSchema;
                for (int i = 0; i < schemaTuple.getChildren().length; ++i) {
                    JsonNode item = jsonNode.get(i);
                    if (item == null) continue;
                    DataParser.parseAccordingSchema(tuple, jsonNode.get(i), schemaTuple.getChild(i));
                }
                return;
            }
            case 3083190: {
                RtSchemaDict schemaDict = (RtSchemaDict)rtSchema;
                for (Map.Entry<String, RtSchema> entry : schemaDict.getChildren().entrySet()) {
                    String key = entry.getKey();
                    JsonNode child = jsonNode.get(key);
                    if (child == null) continue;
                    DataParser.parseAccordingSchema(tuple, jsonNode.get(key), entry.getValue());
                }
                return;
            }
            case -2056817302: {
                tuple[rtSchema.getIndex()] = jsonNode.asInt();
                return;
            }
            case 398795216: {
                tuple[rtSchema.getIndex()] = jsonNode.asLong();
                return;
            }
            case 761287205: {
                tuple[rtSchema.getIndex()] = jsonNode.asDouble();
                return;
            }
            case 1195259493: {
                tuple[rtSchema.getIndex()] = jsonNode.asText();
                return;
            }
            case 344809556: {
                tuple[rtSchema.getIndex()] = jsonNode.asBoolean();
                return;
            }
            case -1405464277: {
                tuple[rtSchema.getIndex()] = jsonNode.decimalValue();
                return;
            }
            case 183594037: {
                int elementType = ((RtSchemaArray)rtSchema).getElementTypeCode();
                switch (elementType) {
                    case -2056817302: {
                        Integer[] integerArray = new Integer[jsonNode.size()];
                        for (int i = 0; i < jsonNode.size(); ++i) {
                            integerArray[i] = jsonNode.get(i).asInt();
                        }
                        tuple[rtSchema.getIndex()] = integerArray;
                        return;
                    }
                    case 398795216: {
                        Long[] longArray = new Long[jsonNode.size()];
                        for (int i = 0; i < jsonNode.size(); ++i) {
                            longArray[i] = jsonNode.get(i).asLong();
                        }
                        tuple[rtSchema.getIndex()] = longArray;
                        return;
                    }
                    case 761287205: {
                        Double[] doubleArray = new Double[jsonNode.size()];
                        for (int i = 0; i < jsonNode.size(); ++i) {
                            doubleArray[i] = jsonNode.get(i).asDouble();
                        }
                        tuple[rtSchema.getIndex()] = doubleArray;
                        return;
                    }
                    case 344809556: {
                        Boolean[] booleanArray = new Boolean[jsonNode.size()];
                        for (int i = 0; i < jsonNode.size(); ++i) {
                            booleanArray[i] = jsonNode.get(i).asBoolean();
                        }
                        tuple[rtSchema.getIndex()] = booleanArray;
                        return;
                    }
                }
                String[] stringArray = new String[jsonNode.size()];
                for (int i = 0; i < jsonNode.size(); ++i) {
                    stringArray[i] = jsonNode.get(i).asText();
                }
                tuple[rtSchema.getIndex()] = stringArray;
                return;
            }
            case 65821278: {
                if (!jsonNode.isArray()) break;
                tuple[rtSchema.getIndex()] = DataParser.jsonNodeValue(jsonNode);
                return;
            }
            case -1383349348: {
                if (!jsonNode.isObject()) break;
                tuple[rtSchema.getIndex()] = DataParser.jsonNodeValue(jsonNode);
                return;
            }
        }
    }

    private static Object toListMapAccordingSchema(Object[] tuple, @Nonnull RtSchema rtSchema) {
        int typeCode = rtSchema.getTypeCode();
        if (typeCode == 110725064) {
            LinkedList<Object> list = new LinkedList<Object>();
            RtSchemaTuple schemaTuple = (RtSchemaTuple)rtSchema;
            for (int i = 0; i < schemaTuple.getChildren().length; ++i) {
                list.add(DataParser.toListMapAccordingSchema(tuple, schemaTuple.getChild(i)));
            }
            return list;
        }
        if (typeCode == 3083190) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            RtSchemaDict schemaDict = (RtSchemaDict)rtSchema;
            for (Map.Entry<String, RtSchema> entry : schemaDict.getChildren().entrySet()) {
                map.put(entry.getKey(), DataParser.toListMapAccordingSchema(tuple, entry.getValue()));
            }
            return map;
        }
        return tuple[rtSchema.getIndex()];
    }

    @Nonnull
    public Object[] parse(String text) throws JsonProcessingException {
        JsonNode jsonNode = this.mapper.readTree(text);
        return this.jsonNodeToTuple(jsonNode);
    }

    @Nonnull
    public Object[] parse(InputStream is) throws IOException {
        JsonNode jsonNode = this.mapper.readTree(new InputStreamReader(is));
        return this.jsonNodeToTuple(jsonNode);
    }

    public String serialize(Object[] tuple) throws JsonProcessingException {
        Object object = DataParser.toListMapAccordingSchema(tuple, this.schemaRoot.getSchema());
        return this.mapper.writeValueAsString(object);
    }

    @Nonnull
    private Object[] jsonNodeToTuple(JsonNode jsonNode) {
        Object[] tuple = new Object[this.schemaRoot.getMaxIndex()];
        DataParser.parseAccordingSchema(tuple, jsonNode, this.schemaRoot.getSchema());
        return tuple;
    }
}

