/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.json.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.dingodb.expr.json.runtime.DataFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class Parser
implements Serializable {
    public static final Parser JSON = new Parser(DataFormat.APPLICATION_JSON);
    public static final Parser YAML = new Parser(DataFormat.APPLICATION_YAML);
    public static final Parser CSV = new Parser(DataFormat.TEXT_CSV);
    private static final long serialVersionUID = -4801322278537134701L;
    protected final ObjectMapper mapper;

    protected Parser(@Nonnull DataFormat format2) {
        switch (format2) {
            case APPLICATION_JSON: {
                this.mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule(new AfterburnerModule())).build();
                Parser.setJsonFeature(this.mapper);
                break;
            }
            case APPLICATION_YAML: {
                YAMLFactory yamlFactory = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
                this.mapper = ((JsonMapper.Builder)JsonMapper.builder(yamlFactory).addModule(new AfterburnerModule())).build();
                Parser.setJsonFeature(this.mapper);
                break;
            }
            case TEXT_CSV: {
                this.mapper = Parser.setCsvFeature(new CsvMapper());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid DataFormat value \"" + (Object)((Object)format2) + "\" for ParserFactory.");
            }
        }
    }

    private static void setJsonFeature(@Nonnull ObjectMapper mapper) {
        mapper.disable(MapperFeature.AUTO_DETECT_FIELDS);
        mapper.disable(MapperFeature.AUTO_DETECT_GETTERS);
        mapper.disable(MapperFeature.AUTO_DETECT_IS_GETTERS);
        mapper.disable(MapperFeature.AUTO_DETECT_SETTERS);
        mapper.disable(MapperFeature.AUTO_DETECT_CREATORS);
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(DeserializationFeature.USE_LONG_FOR_INTS);
    }

    @Nonnull
    private static CsvMapper setCsvFeature(@Nonnull CsvMapper mapper) {
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        mapper.enable(CsvParser.Feature.SKIP_EMPTY_LINES);
        mapper.enable(CsvParser.Feature.TRIM_SPACES);
        return mapper;
    }

    @Nonnull
    public static Parser get(@Nonnull DataFormat format2) {
        switch (format2) {
            case APPLICATION_JSON: {
                return JSON;
            }
            case APPLICATION_YAML: {
                return YAML;
            }
            case TEXT_CSV: {
                return CSV;
            }
        }
        throw new IllegalArgumentException("Unsupported format \"" + (Object)((Object)format2) + "\".");
    }

    public <T> T parse(String json, Class<T> clazz) throws JsonProcessingException {
        return this.mapper.readValue(json, clazz);
    }

    public <T> T parse(InputStream is, Class<T> clazz) throws IOException {
        return this.mapper.readValue(is, clazz);
    }

    public <T> String stringify(T obj) throws JsonProcessingException {
        return this.mapper.writeValueAsString(obj);
    }

    public <T> void writeStream(OutputStream os, T obj) throws IOException {
        this.mapper.writeValue(os, obj);
    }

    public <T> Iterator<T> readValues(InputStream is, Class<T> clazz) throws IOException {
        return this.mapper.readerFor(clazz).readValues(is);
    }
}

