/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.evaluator.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArithmeticEvaluators {
    private static final Logger log = LoggerFactory.getLogger(ArithmeticEvaluators.class);

    private ArithmeticEvaluators() {
    }

    static int pos(int value) {
        return value;
    }

    static long pos(long value) {
        return value;
    }

    static double pos(double value) {
        return value;
    }

    static BigDecimal pos(BigDecimal value) {
        return value;
    }

    static int neg(int value) {
        return -value;
    }

    static long neg(long value) {
        return -value;
    }

    static double neg(double value) {
        return -value;
    }

    @Nonnull
    static BigDecimal neg(@Nonnull BigDecimal value) {
        return value.negate();
    }

    static int add(int value0, int value1) {
        return value0 + value1;
    }

    static long add(long value0, long value1) {
        return value0 + value1;
    }

    static double add(double value0, double value1) {
        return value0 + value1;
    }

    @Nonnull
    static BigDecimal add(@Nonnull BigDecimal value0, BigDecimal value1) {
        return value0.add(value1);
    }

    @Nonnull
    static String add(String s0, String s1) {
        return s0 + s1;
    }

    static int sub(int value0, int value1) {
        return value0 - value1;
    }

    static long sub(long value0, long value1) {
        return value0 - value1;
    }

    static double sub(double value0, double value1) {
        return value0 - value1;
    }

    @Nonnull
    static BigDecimal sub(@Nonnull BigDecimal value0, BigDecimal value1) {
        return value0.subtract(value1);
    }

    static int mul(int value0, int value1) {
        return value0 * value1;
    }

    static long mul(long value0, long value1) {
        return value0 * value1;
    }

    static double mul(double value0, double value1) {
        return value0 * value1;
    }

    @Nonnull
    static BigDecimal mul(@Nonnull BigDecimal value0, BigDecimal value1) {
        return value0.multiply(value1);
    }

    static int div(int value0, int value1) {
        return value0 / value1;
    }

    static long div(long value0, long value1) {
        return value0 / value1;
    }

    static double div(double value0, double value1) {
        return value0 / value1;
    }

    @Nonnull
    static BigDecimal div(@Nonnull BigDecimal value0, BigDecimal value1) {
        return value0.divide(value1, RoundingMode.HALF_EVEN);
    }

    static int abs(int num) {
        return Math.abs(num);
    }

    static long abs(long num) {
        return Math.abs(num);
    }

    static double abs(double num) {
        return Math.abs(num);
    }

    static int min(int value0, int value1) {
        return Math.min(value0, value1);
    }

    static long min(long value0, long value1) {
        return Math.min(value0, value1);
    }

    static double min(double value0, double value1) {
        return Math.min(value0, value1);
    }

    static BigDecimal min(@Nonnull BigDecimal value0, BigDecimal value1) {
        return value0.compareTo(value1) <= 0 ? value0 : value1;
    }

    static String min(@Nonnull String value0, String value1) {
        return value0.compareTo(value1) <= 0 ? value0 : value1;
    }

    static Date min(@Nonnull Date value0, Date value1) {
        return value0.compareTo(value1) <= 0 ? value0 : value1;
    }

    @Nonnull
    static Time min(@Nonnull Time value0, @Nonnull Time value1) {
        return value0.compareTo(value1) <= 0 ? value0 : value1;
    }

    static Timestamp min(@Nonnull Timestamp value0, Timestamp value1) {
        return value0.compareTo(value1) < 0 ? value0 : value1;
    }

    static int max(int value0, int value1) {
        return Math.max(value0, value1);
    }

    static long max(long value0, long value1) {
        return Math.max(value0, value1);
    }

    static double max(double value0, double value1) {
        return Math.max(value0, value1);
    }

    static BigDecimal max(@Nonnull BigDecimal value0, BigDecimal value1) {
        return value0.compareTo(value1) >= 0 ? value0 : value1;
    }

    static String max(@Nonnull String value0, String value1) {
        return value0.compareTo(value1) >= 0 ? value0 : value1;
    }

    static Date max(@Nonnull Date value0, Date value1) {
        return value0.compareTo(value1) >= 0 ? value0 : value1;
    }

    @Nonnull
    static Time max(@Nonnull Time value0, @Nonnull Time value1) {
        return value0.compareTo(value1) >= 0 ? value0 : value1;
    }

    static Timestamp max(@Nonnull Timestamp value0, Timestamp value1) {
        return value0.compareTo(value1) >= 0 ? value0 : value1;
    }
}

