/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.evaluator.cast;

import io.dingodb.expr.runtime.utils.NumberUtils;
import java.math.BigDecimal;
import javax.annotation.Nonnull;

final class IntegerCastEvaluators {
    private IntegerCastEvaluators() {
    }

    static int integerCast(int value) {
        return value;
    }

    static int integerCast(long value) {
        return NumberUtils.checkIntRange(value);
    }

    static int integerCast(double value) {
        return (int)Math.round(value);
    }

    static int integerCast(boolean value) {
        return value ? 1 : 0;
    }

    static int integerCast(@Nonnull BigDecimal value) {
        return value.intValue();
    }

    static int integerCast(@Nonnull String value) {
        return Integer.parseInt(value);
    }
}

