/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.evaluator.cast;

import io.dingodb.expr.runtime.utils.DateTimeUtils;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.annotation.Nonnull;

final class StringCastEvaluators {
    private StringCastEvaluators() {
    }

    @Nonnull
    static String stringCast(int value) {
        return Integer.toString(value);
    }

    @Nonnull
    static String stringCast(long value) {
        return Long.toString(value);
    }

    @Nonnull
    static String stringCast(double value) {
        return Double.toString(value);
    }

    @Nonnull
    static String stringCast(boolean value) {
        return Boolean.toString(value);
    }

    @Nonnull
    static String stringCast(@Nonnull BigDecimal value) {
        return value.toPlainString();
    }

    @Nonnull
    static String stringCast(@Nonnull String value) {
        return value;
    }

    @Nonnull
    static String stringCast(@Nonnull Date value) {
        return DateTimeUtils.dateFormat(value);
    }

    @Nonnull
    static String stringCast(@Nonnull Time value) {
        return DateTimeUtils.timeFormat(value);
    }

    @Nonnull
    static String stringCast(@Nonnull Timestamp value) {
        return DateTimeUtils.timestampFormat(value);
    }

    @Nonnull
    static String stringCast(@Nonnull byte[] value) {
        return new String(value, StandardCharsets.UTF_8);
    }
}

