/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.number;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.function.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoNumberCeilingOp
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DingoNumberCeilingOp.class);

    public DingoNumberCeilingOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    public static BigDecimal ceiling(BigDecimal value) {
        return value.setScale(0, RoundingMode.CEILING);
    }

    @Hints(value={"SqlKind:CEIL"})
    public static BigDecimal ceil(BigDecimal value) {
        return DingoNumberCeilingOp.ceiling(value);
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        if (values[0] == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(String.valueOf(values[0]));
        return DingoNumberCeilingOp.ceiling(value);
    }

    @Override
    public int typeCode() {
        return -1405464277;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoNumberCeilingOp::new;
        }

        public List<String> name() {
            return Arrays.asList("ceiling", "ceil");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoNumberCeilingOp.class.getMethod("ceiling", BigDecimal.class));
                methods.add(DingoNumberCeilingOp.class.getMethod("ceil", BigDecimal.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

