/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.expr.runtime.op.number;

import com.google.auto.service.AutoService;
import io.dingodb.expr.runtime.RtExpr;
import io.dingodb.expr.runtime.op.RtFun;
import io.dingodb.expr.runtime.op.RtOp;
import io.dingodb.func.DingoFuncProvider;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.function.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingoNumberFloorOp
extends RtFun {
    private static final Logger log = LoggerFactory.getLogger(DingoNumberFloorOp.class);

    public DingoNumberFloorOp(@Nonnull RtExpr[] paras) {
        super(paras);
    }

    @Hints(value={"SqlKind:FLOOR"})
    public static BigDecimal floor(BigDecimal value) {
        return value.setScale(0, RoundingMode.FLOOR);
    }

    @Override
    protected Object fun(@Nonnull Object[] values) {
        if (values[0] == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(String.valueOf(values[0]));
        return DingoNumberFloorOp.floor(value);
    }

    @Override
    public int typeCode() {
        return -1405464277;
    }

    @AutoService(value={DingoFuncProvider.class})
    public static class Provider
    implements DingoFuncProvider {
        public Function<RtExpr[], RtOp> supplier() {
            return DingoNumberFloorOp::new;
        }

        public List<String> name() {
            return Arrays.asList("floor");
        }

        public List<Method> methods() {
            try {
                ArrayList<Method> methods = new ArrayList<Method>();
                methods.add(DingoNumberFloorOp.class.getMethod("floor", BigDecimal.class));
                return methods;
            }
            catch (NoSuchMethodException e) {
                log.error("Method:{} NoSuchMethodException:{}", this.name(), e, e);
                throw new RuntimeException(e);
            }
        }
    }
}

